/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.message;

import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.ts.soap.SOAPSampleAdapter;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestCloneIncomplete
extends SOAPTestCase {
    private final boolean preserveModel;

    public TestCloneIncomplete(OMMetaFactory metaFactory, SOAPSpec spec, boolean preserveModel) {
        super(metaFactory, spec);
        this.preserveModel = preserveModel;
        this.addTestParameter("preserveModel", preserveModel);
    }

    protected void runTest() throws Throwable {
        SOAPMessage message = ((SOAPSampleAdapter)SOAPSampleSet.WSA.getMessage(this.spec).getAdapter(SOAPSampleAdapter.class)).getSOAPMessage(this.metaFactory);
        OMCloneOptions options = new OMCloneOptions();
        options.setPreserveModel(this.preserveModel);
        OMInformationItem clone = message.clone(options);
        if (this.preserveModel) {
            TestCloneIncomplete.assertTrue((boolean)(clone instanceof SOAPMessage));
        } else {
            TestCloneIncomplete.assertTrue((boolean)(clone instanceof OMDocument));
            TestCloneIncomplete.assertFalse((boolean)(clone instanceof SOAPMessage));
        }
        TestCloneIncomplete.assertSame((Object)this.soapFactory, (Object)clone.getOMFactory());
    }
}

