/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap11.misc;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.ds.custombuilder.ByteArrayCustomBuilder;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.ts.AxiomTestCase;

public class TestElementPullStreamAndOMExpansion3
extends AxiomTestCase {
    public TestElementPullStreamAndOMExpansion3(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        StAXBuilder builder = (StAXBuilder)OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (InputStream)AbstractTestCase.getTestResource((String)"soap/noprettyprint.xml"), null);
        ByteArrayCustomBuilder customBuilder = new ByteArrayCustomBuilder("utf-8");
        builder.registerCustomBuilderForPayload((CustomBuilder)customBuilder);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLStreamWriter writer = StAXUtils.createXMLStreamWriter((OutputStream)byteArrayOutputStream);
        SOAPEnvelope env = (SOAPEnvelope)builder.getDocumentElement();
        SOAPBody body = env.getBody();
        OMSourcedElement omse = (OMSourcedElement)body.getFirstElement();
        StreamingOMSerializer serializer = new StreamingOMSerializer();
        serializer.serialize(env.getXMLStreamReaderWithoutCaching(), writer);
        writer.flush();
        String outputString = new String(byteArrayOutputStream.toByteArray());
        TestElementPullStreamAndOMExpansion3.assertTrue((String)("Expected output was incorrect.  Received:" + outputString), (outputString != null && !"".equals(outputString) && outputString.length() > 1 ? 1 : 0) != 0);
        int indexHelloWorld = outputString.indexOf("Hello World");
        TestElementPullStreamAndOMExpansion3.assertTrue((String)("Expected output was incorrect.  Received:" + outputString), (indexHelloWorld > 0 ? 1 : 0) != 0);
        int indexHelloWorld2 = outputString.indexOf("Hello World", indexHelloWorld + 1);
        TestElementPullStreamAndOMExpansion3.assertTrue((String)("Expected output was incorrect.  Received:" + outputString), (indexHelloWorld2 < 0 ? 1 : 0) != 0);
        TestElementPullStreamAndOMExpansion3.assertTrue((String)"Expectation is that an OMSourcedElement was created for the payload", (omse != null ? 1 : 0) != 0);
        TestElementPullStreamAndOMExpansion3.assertTrue((String)"Expectation is that the OMSourcedElement was not expanded by serialization ", (!omse.isExpanded() ? 1 : 0) != 0);
    }
}

