/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.fault;

import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestMoreChildrenAddition
extends SOAPTestCase {
    public TestMoreChildrenAddition(OMMetaFactory metaFactory) {
        super(metaFactory, SOAPSpec.SOAP12);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.getDefaultFaultEnvelope();
        SOAPEnvelope soapEnvelope = this.soapFactory.getDefaultFaultEnvelope();
        String errorCodeString = "Some Error occurred !!";
        soapEnvelope.getBody().getFault().getCode().getValue().setText(errorCodeString);
        SOAPFaultCode code = soapEnvelope.getBody().getFault().getCode();
        envelope.getBody().getFault().setCode(code);
        TestMoreChildrenAddition.assertTrue((String)"Parent Value of Code has not been set to new fault", (code.getParent() == envelope.getBody().getFault() ? 1 : 0) != 0);
        TestMoreChildrenAddition.assertTrue((String)"Parent Value of Code is still pointing to old fault", (code.getParent() != soapEnvelope.getBody().getFault() ? 1 : 0) != 0);
        TestMoreChildrenAddition.assertNull((String)"Old fault must not have a fault code", (Object)soapEnvelope.getBody().getFault().getCode());
        TestMoreChildrenAddition.assertEquals((String)("The SOAP Code value must be " + errorCodeString), (String)errorCodeString, (String)envelope.getBody().getFault().getCode().getValue().getText());
    }
}

