/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.header;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestExamineMustUnderstandHeaderBlocks
extends SOAPTestCase {
    public TestExamineMustUnderstandHeaderBlocks(OMMetaFactory metaFactory) {
        super(metaFactory, SOAPSpec.SOAP12);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope soapEnvelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader soapHeader = this.soapFactory.createSOAPHeader(soapEnvelope);
        OMNamespace namespace = this.soapFactory.createOMNamespace("http://www.example.org", "test");
        soapHeader.addHeaderBlock("echoOk1", namespace).setRole("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        SOAPHeaderBlock headerBlock1 = soapHeader.addHeaderBlock("echoOk2", namespace);
        headerBlock1.setRole("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        headerBlock1.setMustUnderstand(true);
        soapHeader.addHeaderBlock("echoOk3", namespace).setMustUnderstand(true);
        Iterator iterator = soapHeader.examineMustUnderstandHeaderBlocks("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        iterator.hasNext();
        SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)iterator.next();
        TestExamineMustUnderstandHeaderBlocks.assertFalse((String)"SOAP Header Test : - examineMustUnderstandHeaderBlocks method returns empty iterator", (headerBlock == null ? 1 : 0) != 0);
        TestExamineMustUnderstandHeaderBlocks.assertTrue((String)"SOAP Header Test : - HeaderBlock local name mismatch", (boolean)headerBlock.getLocalName().equals("echoOk2"));
        TestExamineMustUnderstandHeaderBlocks.assertTrue((String)"SOAP Header Test : - HeaderBlock role value mismatch", (boolean)headerBlock.getRole().equals("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver"));
        TestExamineMustUnderstandHeaderBlocks.assertFalse((String)"SOAP Header Test : - examineMustUnderstandHeaderBlocks method returns an iterator with more than one object", (boolean)iterator.hasNext());
    }
}

