/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.mtom;

import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.soap.MTOMSample;
import org.apache.axiom.util.stax.xop.XOPEncodedStream;
import org.apache.axiom.util.stax.xop.XOPUtils;

public class TestGetXMLStreamReaderMTOMEncoded
extends AxiomTestCase {
    private static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");
    private final boolean cache;

    public TestGetXMLStreamReaderMTOMEncoded(OMMetaFactory metaFactory, boolean cache) {
        super(metaFactory);
        this.cache = cache;
        this.addTestParameter("cache", cache);
    }

    protected void runTest() throws Throwable {
        InputStream inStream = MTOMSample.SAMPLE2.getInputStream();
        Attachments attachments = new Attachments(inStream, MTOMSample.SAMPLE2.getContentType());
        OMElement root = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Attachments)attachments).getDocumentElement();
        XOPEncodedStream xopEncodedStream = XOPUtils.getXOPEncodedStream((XMLStreamReader)root.getXMLStreamReader(this.cache));
        XMLStreamReader xmlStreamReader = xopEncodedStream.getReader();
        DataHandler dh = null;
        while (xmlStreamReader.hasNext() && dh == null) {
            String hrefValue;
            QName qName;
            xmlStreamReader.next();
            if (!xmlStreamReader.isStartElement() || !XOP_INCLUDE.equals(qName = xmlStreamReader.getName()) || (hrefValue = xmlStreamReader.getAttributeValue("", "href")) == null) continue;
            dh = xopEncodedStream.getMimePartProvider().getDataHandler(XOPUtils.getContentIDFromURL((String)hrefValue));
        }
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((dh != null ? 1 : 0) != 0);
        xmlStreamReader.next();
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((boolean)xmlStreamReader.isEndElement());
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((boolean)XOP_INCLUDE.equals(xmlStreamReader.getName()));
        xmlStreamReader.next();
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((boolean)xmlStreamReader.isEndElement());
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((boolean)"name".equals(xmlStreamReader.getLocalName()));
    }
}

