/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts;

import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.util.stax.dialect.StAXDialect;
import org.apache.commons.io.output.NullOutputStream;

public abstract class AxiomTestCase
extends MatrixTestCase {
    public static final StAXParserConfiguration TEST_PARSER_CONFIGURATION = new StAXParserConfiguration(){

        public XMLInputFactory configure(XMLInputFactory factory, StAXDialect dialect) {
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
            return dialect.enableCDataReporting(factory);
        }

        public String toString() {
            return "TEST";
        }
    };
    protected final OMMetaFactory metaFactory;

    public AxiomTestCase(OMMetaFactory metaFactory) {
        this.metaFactory = metaFactory;
    }

    protected void assertConsumed(OMContainer container) {
        boolean isConsumed;
        AxiomTestCase.assertFalse((String)"Expected the node to be incomplete", (boolean)container.isComplete());
        try {
            container.serialize((OutputStream)new NullOutputStream());
            isConsumed = false;
        }
        catch (Exception ex) {
            isConsumed = true;
        }
        AxiomTestCase.assertTrue((boolean)isConsumed);
    }

    protected static int getChildrenCount(Iterator childrenIter) {
        int childCount = 0;
        while (childrenIter.hasNext()) {
            childrenIter.next();
            ++childCount;
        }
        return childCount;
    }

    protected static int getNumberOfOccurrences(String xml, String pattern) {
        int index = -1;
        int count = 0;
        while ((index = xml.indexOf(pattern, index + 1)) != -1) {
            ++count;
        }
        return count;
    }
}

