/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.dimension.BuilderFactory;
import org.apache.axiom.ts.jaxp.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

final class DOMBuilderFactory
extends BuilderFactory {
    private final DOMImplementation implementation;

    DOMBuilderFactory(DOMImplementation implementation) {
        this.implementation = implementation;
    }

    @Override
    public boolean isDeferredParsing() {
        return true;
    }

    @Override
    public void configureXMLStreamReaderComparator(XMLStreamReaderComparator comparator) {
        comparator.setCompareCharacterEncodingScheme(this.implementation.isDOM3());
        comparator.setCompareEncoding(this.implementation.isDOM3());
        comparator.setCompareInternalSubset(this.implementation.supportsGetInternalSubset());
        comparator.setTreatSpaceAsCharacters(!this.implementation.isDOM3());
        comparator.setCompareEntityReplacementValue(false);
        comparator.setSortAttributes(true);
    }

    public void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("source", this.implementation.getName() + "-dom");
    }

    @Override
    public OMXMLParserWrapper getBuilder(OMMetaFactory metaFactory, InputSource inputSource) throws Exception {
        DocumentBuilderFactory dbf = this.implementation.newDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        Document document = dbf.newDocumentBuilder().parse(inputSource);
        return OMXMLBuilderFactory.createOMBuilder((OMFactory)metaFactory.getOMFactory(), (Node)document, (boolean)false);
    }
}

