/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.dimension.BuilderFactory;
import org.apache.axiom.ts.dimension.CoalescingXMLFilter;
import org.apache.axiom.ts.jaxp.SAXImplementation;
import org.xml.sax.InputSource;

final class SAXBuilderFactory
extends BuilderFactory {
    private final SAXImplementation implementation;

    SAXBuilderFactory(SAXImplementation implementation) {
        this.implementation = implementation;
    }

    @Override
    public boolean isDeferredParsing() {
        return false;
    }

    @Override
    public void configureXMLStreamReaderComparator(XMLStreamReaderComparator comparator) {
        comparator.setCompareCharacterEncodingScheme(false);
        comparator.setCompareEncoding(false);
        comparator.setCompareInternalSubset(this.implementation.reportsExternalSubsetEntity());
    }

    public void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("source", this.implementation.getName() + "-sax");
    }

    @Override
    public OMXMLParserWrapper getBuilder(OMMetaFactory metaFactory, InputSource inputSource) throws Exception {
        SAXParserFactory factory = this.implementation.newSAXParserFactory();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser parser = factory.newSAXParser();
        SAXSource source = new SAXSource(new CoalescingXMLFilter(parser.getXMLReader()), inputSource);
        return OMXMLBuilderFactory.createOMBuilder((OMFactory)metaFactory.getOMFactory(), (SAXSource)source, (boolean)false);
    }
}

