/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.jaxp.DOMImplementation;
import org.apache.axiom.ts.xml.XMLSample;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class TestCreateOMBuilderFromDOM
extends ConformanceTestCase {
    private final DOMImplementation implementation;
    private final Boolean expandEntityReferences;

    public TestCreateOMBuilderFromDOM(OMMetaFactory metaFactory, XMLSample file, DOMImplementation implementation, Boolean expandEntityReferences) {
        super(metaFactory, file);
        this.implementation = implementation;
        this.addTestParameter("implementation", implementation.getName());
        this.expandEntityReferences = expandEntityReferences;
        if (expandEntityReferences != null) {
            this.addTestParameter("expandEntityReferences", expandEntityReferences);
        }
    }

    private Document loadDocument(boolean expandEntityReferences) throws Exception {
        DocumentBuilderFactory factory = this.implementation.newDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(expandEntityReferences);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        return documentBuilder.parse(this.file.getUrl().toString());
    }

    protected void runTest() throws Throwable {
        Document document = this.loadDocument(false);
        OMXMLParserWrapper builder = this.expandEntityReferences == null ? OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Source)new DOMSource(document)) : OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Node)document, (boolean)this.expandEntityReferences);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        builder.getDocument().serialize((OutputStream)baos);
        InputSource actual = new InputSource();
        actual.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
        actual.setSystemId(this.file.getUrl().toString());
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)actual)).ignoringWhitespaceInPrologAndEpilog().treatingElementContentWhitespaceAsText(!this.implementation.isDOM3()).hasSameContentAs((Object)this.loadDocument(this.expandEntityReferences == null || this.expandEntityReferences != false));
    }
}

