/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.container;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.dimension.serialization.XML;
import org.apache.axiom.ts.om.container.OMContainerExtractor;
import org.apache.axiom.ts.xml.XMLSample;
import org.apache.commons.io.IOUtils;
import org.xml.sax.InputSource;

public class TestSerialize
extends ConformanceTestCase {
    private final OMContainerExtractor containerExtractor;
    private final SerializationStrategy serializationStrategy;

    public TestSerialize(OMMetaFactory metaFactory, XMLSample file, OMContainerExtractor containerExtractor, SerializationStrategy serializationStrategy) {
        super(metaFactory, file);
        this.containerExtractor = containerExtractor;
        this.serializationStrategy = serializationStrategy;
        containerExtractor.addTestParameters(this);
        serializationStrategy.addTestParameters(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        try (OMXMLParserWrapper builder = this.metaFactory.createOMBuilder(this.metaFactory.getOMFactory(), TEST_PARSER_CONFIGURATION, new InputSource(this.file.getUrl().toString()));){
            OMContainer container = this.containerExtractor.getContainer(builder);
            InputSource[] control = this.duplicateInputSource(this.containerExtractor.getControl(this.file.getInputStream()));
            XML actual = this.serializationStrategy.serialize(container);
            try {
                String systemId = new URL(this.file.getUrl(), "dummy.xml").toString();
                control[0].setSystemId(systemId);
                InputSource actualIS = actual.getInputSource();
                actualIS.setSystemId(systemId);
                ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)actualIS)).ignoringElementContentWhitespace().hasSameContentAs((Object)control[0]);
            }
            catch (Throwable ex) {
                System.out.println("Control:");
                this.dumpInputSource(control[1]);
                System.out.println("Actual:");
                actual.dump(System.out);
                throw ex;
            }
            if (this.serializationStrategy.isCaching()) {
                TestSerialize.assertTrue((boolean)container.isComplete());
            } else {
                TestSerialize.assertFalse((boolean)container.isComplete());
            }
        }
    }

    private InputSource[] duplicateInputSource(InputSource is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is.getByteStream(), (OutputStream)baos);
        byte[] content = baos.toByteArray();
        return new InputSource[]{new InputSource(new ByteArrayInputStream(content)), new InputSource(new ByteArrayInputStream(content))};
    }

    private void dumpInputSource(InputSource is) throws IOException {
        IOUtils.copy((InputStream)is.getByteStream(), (OutputStream)System.out);
        System.out.println();
    }
}

