/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.document;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.Reader;
import java.io.StringReader;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;

public class TestRemoveChildren
extends AxiomTestCase {
    private final boolean complete;
    private final boolean accessDocumentElement;

    public TestRemoveChildren(OMMetaFactory metaFactory, boolean complete, boolean accessDocumentElement) {
        super(metaFactory);
        this.complete = complete;
        this.accessDocumentElement = accessDocumentElement;
        this.addTestParameter("complete", complete);
        this.addTestParameter("accessDocumentElement", accessDocumentElement);
    }

    protected void runTest() throws Throwable {
        OMElement documentElement;
        OMFactory factory = this.metaFactory.getOMFactory();
        OMDocument document = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader("<?pi data?><root>text</root>")).getDocument();
        if (this.complete) {
            document.build();
        }
        OMProcessingInstruction firstChild = (OMProcessingInstruction)document.getFirstOMChild();
        if (this.accessDocumentElement) {
            documentElement = document.getOMDocumentElement();
            TestRemoveChildren.assertEquals((boolean)this.complete, (boolean)documentElement.isComplete());
        } else {
            documentElement = null;
        }
        document.removeChildren();
        TestRemoveChildren.assertNull((Object)firstChild.getParent());
        TestRemoveChildren.assertNull((Object)firstChild.getPreviousOMSibling());
        TestRemoveChildren.assertNull((Object)firstChild.getNextOMSibling());
        if (documentElement != null) {
            TestRemoveChildren.assertNull((Object)documentElement.getParent());
            TestRemoveChildren.assertNull((Object)documentElement.getPreviousOMSibling());
            TestRemoveChildren.assertNull((Object)documentElement.getNextOMSibling());
            TestRemoveChildren.assertEquals((String)"text", (String)documentElement.getText());
        }
        TestRemoveChildren.assertNull((Object)document.getFirstOMChild());
        document.addChild((OMNode)factory.createOMElement("newroot", null));
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that(XMLTruth.xml(OMDocument.class, (Object)document))).hasSameContentAs((Object)"<newroot/>");
    }
}

