/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.document.sr;

import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.ext.stax.DTDReader;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.ts.AxiomTestCase;

public class TestDTDReaderFromParser
extends AxiomTestCase {
    private final boolean build;
    private final boolean cache;

    public TestDTDReaderFromParser(OMMetaFactory metaFactory, boolean build, boolean cache) {
        super(metaFactory);
        this.build = build;
        this.cache = cache;
        this.addTestParameter("build", build);
        this.addTestParameter("cache", cache);
    }

    protected void runTest() throws Throwable {
        OMDocument doc = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (StAXParserConfiguration)StAXParserConfiguration.STANDALONE, (InputStream)TestDTDReaderFromParser.class.getResourceAsStream("/web_w_dtd.xml")).getDocument();
        if (this.build) {
            doc.build();
        }
        XMLStreamReader reader = doc.getXMLStreamReader(this.cache);
        DTDReader dtdReader = (DTDReader)reader.getProperty(DTDReader.PROPERTY);
        TestDTDReaderFromParser.assertNotNull((Object)dtdReader);
        while (reader.next() != 11) {
        }
        TestDTDReaderFromParser.assertEquals((String)"web-app", (String)dtdReader.getRootName());
        TestDTDReaderFromParser.assertEquals((String)"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", (String)dtdReader.getPublicId());
        TestDTDReaderFromParser.assertEquals((String)"http://java.sun.com/dtd/web-app_2_3.dtd", (String)dtdReader.getSystemId());
    }
}

