/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;

public class TestCloneOMElementNamespaceRepairing
extends AxiomTestCase {
    public TestCloneOMElementNamespaceRepairing(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement root = factory.createOMElement("root", null);
        OMNamespace ns1 = root.declareNamespace("urn:ns1", "ns1");
        OMNamespace ns2 = root.declareNamespace("urn:ns2", "ns2");
        root.declareNamespace("urn:ns3", "ns3");
        OMElement child = factory.createOMElement("child", ns1, (OMContainer)root);
        child.addAttribute("attr", "value", ns2);
        TestCloneOMElementNamespaceRepairing.assertFalse((boolean)child.getAllDeclaredNamespaces().hasNext());
        OMElement clone = child.cloneOMElement();
        HashSet<OMNamespace> expectedNSDecls = new HashSet<OMNamespace>();
        expectedNSDecls.add(ns1);
        expectedNSDecls.add(ns2);
        HashSet<OMNamespace> actualNSDecls = new HashSet<OMNamespace>();
        Iterator it = clone.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            actualNSDecls.add((OMNamespace)it.next());
        }
        TestCloneOMElementNamespaceRepairing.assertEquals(expectedNSDecls, actualNSDecls);
    }
}

