/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetNamespacesInScope
extends AxiomTestCase {
    public TestGetNamespacesInScope(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMElement element = AXIOMUtil.stringToOM((OMFactory)this.metaFactory.getOMFactory(), (String)"<a xmlns:ns1='urn:ns1'><b xmlns:ns2='urn:ns2'/></a>");
        boolean ns1seen = false;
        boolean ns2seen = false;
        Iterator it = element.getFirstElement().getNamespacesInScope();
        int count = 0;
        while (it.hasNext()) {
            OMNamespace ns = (OMNamespace)it.next();
            ++count;
            if (ns.getPrefix().equals("ns1")) {
                ns1seen = true;
                TestGetNamespacesInScope.assertEquals((String)"urn:ns1", (String)ns.getNamespaceURI());
                continue;
            }
            if (ns.getPrefix().equals("ns2")) {
                ns2seen = true;
                TestGetNamespacesInScope.assertEquals((String)"urn:ns2", (String)ns.getNamespaceURI());
                continue;
            }
            TestGetNamespacesInScope.fail((String)("Unexpected prefix: " + ns.getPrefix()));
        }
        TestGetNamespacesInScope.assertEquals((String)"Number of namespaces in scope", (int)2, (int)count);
        TestGetNamespacesInScope.assertTrue((boolean)ns1seen);
        TestGetNamespacesInScope.assertTrue((boolean)ns2seen);
    }
}

