/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.testutils.activation.RandomDataSource;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetTextAsStreamWithoutCaching
extends AxiomTestCase {
    public TestGetTextAsStreamWithoutCaching(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        Charset charset = Charset.forName("ascii");
        OMFactory factory = this.metaFactory.getOMFactory();
        RandomDataSource ds = new RandomDataSource(654321L, 64, 128, 20000000L);
        Vector<InputStream> v = new Vector<InputStream>();
        v.add(new ByteArrayInputStream("<root><a>".getBytes(charset)));
        v.add(ds.getInputStream());
        v.add(new ByteArrayInputStream("</a><b/></root>".getBytes(charset)));
        OMElement root = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (StAXParserConfiguration)StAXParserConfiguration.NON_COALESCING, (InputStream)new SequenceInputStream(v.elements()), (String)"ascii").getDocumentElement();
        OMElement child = (OMElement)root.getFirstOMChild();
        Reader in = child.getTextAsStream(false);
        IOTestUtils.compareStreams((Reader)new InputStreamReader(ds.getInputStream(), charset), (String)"expected", (Reader)in, (String)"actual");
        in.close();
        child = (OMElement)child.getNextOMSibling();
        Truth.assertThat((String)child.getLocalName()).isEqualTo((Object)"b");
    }
}

