/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.factory;

import com.google.common.truth.Truth;
import javax.activation.DataHandler;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.util.UIDGenerator;

public class TestCreateOMTextFromDataHandlerProvider
extends AxiomTestCase {
    private final boolean nullContentID;

    public TestCreateOMTextFromDataHandlerProvider(OMMetaFactory metaFactory, boolean nullContentID) {
        super(metaFactory);
        this.nullContentID = nullContentID;
        this.addTestParameter("nullContentId", nullContentID);
    }

    protected void runTest() throws Throwable {
        TestDataHandlerProvider prov = new TestDataHandlerProvider();
        OMFactory factory = this.metaFactory.getOMFactory();
        String contentID = this.nullContentID ? null : UIDGenerator.generateContentId();
        OMText text = factory.createOMText(contentID, (DataHandlerProvider)prov, true);
        TestCreateOMTextFromDataHandlerProvider.assertFalse((boolean)prov.isDataHandlerCreated());
        TestCreateOMTextFromDataHandlerProvider.assertEquals((Object)((DataHandler)text.getDataHandler()).getContent(), (Object)"Data");
        TestCreateOMTextFromDataHandlerProvider.assertTrue((boolean)prov.isDataHandlerCreated());
        if (contentID == null) {
            Truth.assertThat((String)text.getContentID()).isNotNull();
        } else {
            Truth.assertThat((String)text.getContentID()).isEqualTo((Object)contentID);
        }
    }

    static class TestDataHandlerProvider
    implements DataHandlerProvider {
        private DataHandler dh;

        TestDataHandlerProvider() {
        }

        public boolean isLoaded() {
            return false;
        }

        public DataHandler getDataHandler() {
            if (this.dh == null) {
                this.dh = new DataHandler((Object)"Data", "text/plain");
            }
            return this.dh;
        }

        public boolean isDataHandlerCreated() {
            return this.dh != null;
        }
    }
}

