/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.ts.AxiomTestCase;

public class TestByteArrayDS
extends AxiomTestCase {
    public TestByteArrayDS(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        String localName = "myPayload";
        String encoding = "utf-8";
        String payload1 = "<tns:myPayload xmlns:tns=\"urn://test\">Payload One</tns:myPayload>";
        OMNamespace ns = factory.createOMNamespace("urn://test", "tns");
        ByteArrayDataSource bads1 = new ByteArrayDataSource(payload1.getBytes(encoding), encoding);
        OMElement parent = factory.createOMElement("root", null);
        OMSourcedElement omse = factory.createOMElement((OMDataSource)bads1, localName, ns);
        parent.addChild((OMNode)omse);
        OMNode firstChild = parent.getFirstOMChild();
        TestByteArrayDS.assertTrue((String)"Expected OMSourcedElement child", (boolean)(firstChild instanceof OMSourcedElement));
        OMSourcedElement child = (OMSourcedElement)firstChild;
        TestByteArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        TestByteArrayDS.assertTrue((String)"OMSourcedElement should be backed by a ByteArrayDataSource", (boolean)(child.getDataSource() instanceof ByteArrayDataSource));
        XMLStreamReader reader = child.getXMLStreamReader();
        reader.next();
        TestByteArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        parent.serialize((OutputStream)baos);
        String output = baos.toString(encoding);
        TestByteArrayDS.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload1) > 0 ? 1 : 0) != 0);
        TestByteArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        parent.build();
        TestByteArrayDS.assertTrue((String)"OMSourcedElement is expanded after build().  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        parent.buildWithAttachments();
        TestByteArrayDS.assertTrue((String)"OMSourcedElement is expanded after buildWithAttachments().  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        OMDataSourceExt ds = (OMDataSourceExt)child.getDataSource();
        byte[] bytes = ds.getXMLBytes("UTF-16");
        String payload = new String(bytes, "utf-16");
        TestByteArrayDS.assertTrue((String)"The obtained bytes did not match the payload", (boolean)payload1.equals(payload));
        OMOutputFormat outputFormat = new OMOutputFormat();
        baos = new ByteArrayOutputStream();
        ds.serialize((OutputStream)baos, outputFormat);
        output = baos.toString("utf-8");
        TestByteArrayDS.assertTrue((String)"The obtained bytes did not match the payload", (boolean)payload1.equals(output));
    }
}

