/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.sourcedelement.TestDocument;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public class TestName2DefaultPrefix
extends AxiomTestCase {
    public TestName2DefaultPrefix(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory f = this.metaFactory.getOMFactory();
        OMNamespace rootNS = f.createOMNamespace("http://sampleroot", "rootPrefix");
        OMNamespace ns = f.createOMNamespace("http://www.sosnoski.com/uwjws/library", "DUMMYPREFIX");
        OMSourcedElement element = f.createOMElement((OMDataSource)new PullOMDataSource(TestDocument.DOCUMENT1.getContent()), "library", ns);
        OMElement root = f.createOMElement("root", rootNS);
        root.addChild((OMNode)element);
        TestName2DefaultPrefix.assertTrue((boolean)element.getLocalName().equals("library"));
        TestName2DefaultPrefix.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals("http://www.sosnoski.com/uwjws/library"));
        TestName2DefaultPrefix.assertTrue((boolean)element.getNamespace().getPrefix().equals("DUMMYPREFIX"));
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlwriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        root.serializeAndConsume((Writer)writer);
        xmlwriter.flush();
        String result = writer.toString();
        TestName2DefaultPrefix.assertTrue((boolean)element.getLocalName().equals("library"));
        TestName2DefaultPrefix.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals("http://www.sosnoski.com/uwjws/library"));
        TestName2DefaultPrefix.assertTrue((boolean)element.getNamespace().getPrefix().equals("DUMMYPREFIX"));
        TestName2DefaultPrefix.assertTrue((result.indexOf("DUMMYPREFIX") < 0 ? 1 : 0) != 0);
        TestName2DefaultPrefix.assertTrue((String)("Serialized text error" + result), (result.indexOf("1930110111") > 0 ? 1 : 0) != 0);
    }
}

