/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.CharArrayDataSource;
import org.apache.axiom.ts.AxiomTestCase;

public class TestSerializeModifiedOMSEWithNonDestructiveDataSource
extends AxiomTestCase {
    public TestSerializeModifiedOMSEWithNonDestructiveDataSource(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        CharArrayDataSource ds = new CharArrayDataSource("<element><child/></element>".toCharArray());
        TestSerializeModifiedOMSEWithNonDestructiveDataSource.assertFalse((boolean)ds.isDestructiveWrite());
        OMFactory f = this.metaFactory.getOMFactory();
        OMSourcedElement element = f.createOMElement((OMDataSource)ds, "element", null);
        element.getFirstElement().setText("TEST");
        StringWriter sw = new StringWriter();
        element.serialize((Writer)sw);
        TestSerializeModifiedOMSEWithNonDestructiveDataSource.assertTrue((sw.toString().indexOf("TEST") != -1 ? 1 : 0) != 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        element.serialize((OutputStream)baos);
        TestSerializeModifiedOMSEWithNonDestructiveDataSource.assertTrue((new String(baos.toByteArray(), "UTF-8").indexOf("TEST") != -1 ? 1 : 0) != 0);
        TestSerializeModifiedOMSEWithNonDestructiveDataSource.assertTrue((element.toString().indexOf("TEST") != -1 ? 1 : 0) != 0);
    }
}

