/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement.push;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.testutils.activation.RandomDataSource;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.om.sourcedelement.push.PushOMDataSourceScenario;
import org.apache.axiom.util.stax.XMLStreamWriterUtils;
import org.junit.Assert;

public class WriteDataHandlerProviderScenario
implements PushOMDataSourceScenario {
    private final DataHandler dh = new DataHandler((DataSource)new RandomDataSource(1024L));
    private final DataHandlerProvider dhp = new DataHandlerProvider(){

        public boolean isLoaded() {
            return true;
        }

        public DataHandler getDataHandler() throws IOException {
            return WriteDataHandlerProviderScenario.this.dh;
        }
    };

    public void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("scenario", "writeDataHandlerProvider");
    }

    @Override
    public Map getNamespaceContext() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(null, "root", null);
        try {
            XMLStreamWriterUtils.writeDataHandler((XMLStreamWriter)writer, (DataHandlerProvider)this.dhp, null, (boolean)true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
        writer.writeEndElement();
    }

    @Override
    public void validate(OMElement element, boolean dataHandlersPreserved) throws Throwable {
        OMText child = (OMText)element.getFirstOMChild();
        if (dataHandlersPreserved) {
            Assert.assertTrue((boolean)child.isBinary());
            Assert.assertSame((Object)this.dh, (Object)child.getDataHandler());
        } else {
            child.setBinary(true);
            IOTestUtils.compareStreams((InputStream)this.dh.getInputStream(), (InputStream)((DataHandler)child.getDataHandler()).getInputStream());
        }
    }
}

