/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.xop;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.soap.MTOMSample;

public class TestSerialize
extends AxiomTestCase {
    private final boolean base64;

    public TestSerialize(OMMetaFactory metaFactory, boolean base64) {
        super(metaFactory);
        this.base64 = base64;
        this.addTestParameter("base64", base64);
    }

    protected void runTest() throws Throwable {
        MTOMSample testMessage = MTOMSample.SAMPLE1;
        InputStream inStream = testMessage.getInputStream();
        Attachments attachments = new Attachments(inStream, testMessage.getContentType());
        OMOutputFormat oof = new OMOutputFormat();
        oof.setDoOptimize(true);
        oof.setMimeBoundary(testMessage.getBoundary());
        oof.setRootContentId(testMessage.getStart());
        if (this.base64) {
            oof.setProperty("org.apache.axiom.om.OMFormat.use.cteBase64.forNonTextualAttachments", (Object)Boolean.TRUE);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter((OutputStream)baos, oof);
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (StAXParserConfiguration)StAXParserConfiguration.DEFAULT, (Attachments)attachments);
        OMElement om = builder.getDocumentElement();
        om.serialize((XMLStreamWriter)writer);
        om.close(false);
        String out = baos.toString();
        if (this.base64) {
            TestSerialize.assertTrue((out.indexOf("base64") != -1 ? 1 : 0) != 0);
            TestSerialize.assertTrue((out.indexOf("GBgcGBQgHBwcJCQgKDBQNDAsL") != -1 ? 1 : 0) != 0);
        } else {
            TestSerialize.assertTrue((out.indexOf("base64") == -1 ? 1 : 0) != 0);
        }
    }
}

