/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.xop;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.testutils.activation.TestDataSource;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.util.stax.xop.ContentIDGenerator;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.apache.axiom.util.stax.xop.OptimizationPolicy;
import org.apache.axiom.util.stax.xop.XOPDecodingStreamReader;
import org.apache.axiom.util.stax.xop.XOPEncodingStreamReader;

public class XOPRoundtripTest
extends AxiomTestCase {
    public XOPRoundtripTest(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        DataHandler dh = new DataHandler((DataSource)new TestDataSource(120, Runtime.getRuntime().maxMemory()));
        OMElement element1 = factory.createOMElement(new QName("test"));
        element1.addChild((OMNode)factory.createOMText((Object)dh, true));
        XMLStreamReader originalReader = element1.getXMLStreamReader();
        XOPEncodingStreamReader encodedReader = new XOPEncodingStreamReader(originalReader, ContentIDGenerator.DEFAULT, OptimizationPolicy.DEFAULT);
        XOPDecodingStreamReader decodedReader = new XOPDecodingStreamReader((XMLStreamReader)encodedReader, (MimePartProvider)encodedReader);
        OMElement element2 = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)factory, (XMLStreamReader)decodedReader).getDocumentElement();
        OMText child = (OMText)element2.getFirstOMChild();
        XOPRoundtripTest.assertNotNull((Object)child);
        XOPRoundtripTest.assertTrue((boolean)child.isBinary());
        XOPRoundtripTest.assertTrue((boolean)child.isOptimized());
        XOPRoundtripTest.assertSame((Object)dh, (Object)child.getDataHandler());
    }
}

