/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.testutils.suite.MatrixTestSuiteBuilder;
import org.apache.axiom.ts.dimension.ExpansionStrategy;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.soap.BooleanLiteral;
import org.apache.axiom.ts.soap.HeaderBlockAttribute;
import org.apache.axiom.ts.soap.SOAPElementType;
import org.apache.axiom.ts.soap.SOAPElementTypeAdapter;
import org.apache.axiom.ts.soap.SOAPFaultChild;
import org.apache.axiom.ts.soap.SOAPSample;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SimpleSOAPSample;
import org.apache.axiom.ts.soap.body.TestAddFault1;
import org.apache.axiom.ts.soap.body.TestAddFault2;
import org.apache.axiom.ts.soap.body.TestCloneOMElement;
import org.apache.axiom.ts.soap.body.TestGetFault;
import org.apache.axiom.ts.soap.body.TestGetFaultFakeFault;
import org.apache.axiom.ts.soap.body.TestGetFaultNoFault;
import org.apache.axiom.ts.soap.body.TestGetFaultWithParser;
import org.apache.axiom.ts.soap.body.TestGetFaultWithParserNoFault;
import org.apache.axiom.ts.soap.body.TestGetFirstElementLocalNameEmptyBody;
import org.apache.axiom.ts.soap.body.TestGetFirstElementLocalNameWithParser;
import org.apache.axiom.ts.soap.body.TestGetFirstElementLocalNameWithParser2;
import org.apache.axiom.ts.soap.body.TestGetFirstElementLocalNameWithParserNoLookahead;
import org.apache.axiom.ts.soap.body.TestGetFirstElementNSEmptyBody;
import org.apache.axiom.ts.soap.body.TestGetFirstElementNSWithParser;
import org.apache.axiom.ts.soap.body.TestHasFault;
import org.apache.axiom.ts.soap.body.TestHasFaultAfterReplace;
import org.apache.axiom.ts.soap.body.TestHasFaultFakeFault;
import org.apache.axiom.ts.soap.body.TestHasFaultNoFault;
import org.apache.axiom.ts.soap.body.TestHasFaultWithOMSEUnknownName;
import org.apache.axiom.ts.soap.body.TestHasFaultWithParserNoFault;
import org.apache.axiom.ts.soap.builder.BadInputTest;
import org.apache.axiom.ts.soap.builder.MessageTest;
import org.apache.axiom.ts.soap.builder.TestCommentInEpilog;
import org.apache.axiom.ts.soap.builder.TestCommentInProlog;
import org.apache.axiom.ts.soap.builder.TestCreateSOAPModelBuilderFromDOMSource;
import org.apache.axiom.ts.soap.builder.TestCreateSOAPModelBuilderMTOMContentTypeMismatch;
import org.apache.axiom.ts.soap.builder.TestDTD;
import org.apache.axiom.ts.soap.builder.TestRegisterCustomBuilder;
import org.apache.axiom.ts.soap.builder.TestRegisterCustomBuilderForPayload;
import org.apache.axiom.ts.soap.builder.TestRegisterCustomBuilderForPayloadAfterSOAPFaultCheck;
import org.apache.axiom.ts.soap.envelope.TestAddElementAfterBody;
import org.apache.axiom.ts.soap.envelope.TestAddHeaderToIncompleteEnvelope;
import org.apache.axiom.ts.soap.envelope.TestBodyHeaderOrder;
import org.apache.axiom.ts.soap.envelope.TestCloneWithSourcedElement1;
import org.apache.axiom.ts.soap.envelope.TestCloneWithSourcedElement2;
import org.apache.axiom.ts.soap.envelope.TestDetach;
import org.apache.axiom.ts.soap.envelope.TestGetBody;
import org.apache.axiom.ts.soap.envelope.TestGetBodyOnEmptyEnvelope;
import org.apache.axiom.ts.soap.envelope.TestGetBodyOnEnvelopeWithHeaderOnly;
import org.apache.axiom.ts.soap.envelope.TestGetBodyWithParser;
import org.apache.axiom.ts.soap.envelope.TestGetHeader;
import org.apache.axiom.ts.soap.envelope.TestGetHeaderWithParser;
import org.apache.axiom.ts.soap.envelope.TestGetHeaderWithParserNoHeader;
import org.apache.axiom.ts.soap.envelope.TestGetOrCreateHeader;
import org.apache.axiom.ts.soap.envelope.TestGetOrCreateHeaderWithParserNoHeader;
import org.apache.axiom.ts.soap.envelope.TestGetSOAPBodyFirstElementLocalNameAndNS;
import org.apache.axiom.ts.soap.envelope.TestGetSOAPBodyFirstElementLocalNameAndNSWithParser;
import org.apache.axiom.ts.soap.envelope.TestGetXMLStreamReaderWithoutCachingWithPartiallyBuiltHeaderBlock;
import org.apache.axiom.ts.soap.envelope.TestHasFaultWithParser;
import org.apache.axiom.ts.soap.envelope.TestHasFaultWithParserOptimized;
import org.apache.axiom.ts.soap.envelope.TestSerializeAndConsumeWithOMSEInBody;
import org.apache.axiom.ts.soap.factory.TestCreateDefaultSOAPMessage;
import org.apache.axiom.ts.soap.factory.TestCreateSOAPElement;
import org.apache.axiom.ts.soap.factory.TestCreateSOAPElementWithNullParent;
import org.apache.axiom.ts.soap.factory.TestCreateSOAPElementWithParent;
import org.apache.axiom.ts.soap.factory.TestCreateSOAPEnvelopeWithCustomPrefix;
import org.apache.axiom.ts.soap.factory.TestCreateSOAPFaultWithException;
import org.apache.axiom.ts.soap.factory.TestFactoryIsSingleton;
import org.apache.axiom.ts.soap.factory.TestGetDefaultEnvelope;
import org.apache.axiom.ts.soap.factory.TestGetDefaultFaultEnvelope;
import org.apache.axiom.ts.soap.factory.TestGetMetaFactory;
import org.apache.axiom.ts.soap.factory.TestGetNamespace;
import org.apache.axiom.ts.soap.fault.TestChildOrder;
import org.apache.axiom.ts.soap.fault.TestGetCodeWithParser;
import org.apache.axiom.ts.soap.fault.TestGetDetailWithParser;
import org.apache.axiom.ts.soap.fault.TestGetException;
import org.apache.axiom.ts.soap.fault.TestGetReasonWithParser;
import org.apache.axiom.ts.soap.fault.TestSetException;
import org.apache.axiom.ts.soap.fault.TestWrongParent1;
import org.apache.axiom.ts.soap.fault.TestWrongParent2;
import org.apache.axiom.ts.soap.fault.TestWrongParent3;
import org.apache.axiom.ts.soap.faultcode.TestGetValueAsQName;
import org.apache.axiom.ts.soap.faultdetail.TestAddDetailEntry;
import org.apache.axiom.ts.soap.faultdetail.TestDetailEntriesUsingDefaultNamespaceWithParser;
import org.apache.axiom.ts.soap.faultdetail.TestGetAllDetailEntries;
import org.apache.axiom.ts.soap.faultdetail.TestGetAllDetailEntriesWithParser;
import org.apache.axiom.ts.soap.faultdetail.TestSerialization;
import org.apache.axiom.ts.soap.faultdetail.TestWSCommons202;
import org.apache.axiom.ts.soap.faultnode.TestGetFaultNodeValue;
import org.apache.axiom.ts.soap.faultnode.TestGetFaultNodeValueWithParser;
import org.apache.axiom.ts.soap.faultnode.TestSetFaultNodeValue;
import org.apache.axiom.ts.soap.faultrole.TestGetRoleValue;
import org.apache.axiom.ts.soap.faultrole.TestGetRoleValueWithParser;
import org.apache.axiom.ts.soap.faultrole.TestSetRoleValue;
import org.apache.axiom.ts.soap.faulttext.TestGetLang;
import org.apache.axiom.ts.soap.faulttext.TestGetLangFromParser;
import org.apache.axiom.ts.soap.faulttext.TestSetLang;
import org.apache.axiom.ts.soap.header.TestAddHeaderBlock;
import org.apache.axiom.ts.soap.header.TestAddHeaderBlockFromQName;
import org.apache.axiom.ts.soap.header.TestAddHeaderBlockFromQNameWithoutNamespace;
import org.apache.axiom.ts.soap.header.TestAddHeaderBlockWithoutNamespace1;
import org.apache.axiom.ts.soap.header.TestAddHeaderBlockWithoutNamespace2;
import org.apache.axiom.ts.soap.header.TestDiscardIncomplete;
import org.apache.axiom.ts.soap.header.TestDiscardPartiallyBuilt;
import org.apache.axiom.ts.soap.header.TestExamineAllHeaderBlocks;
import org.apache.axiom.ts.soap.header.TestExamineAllHeaderBlocksWithParser;
import org.apache.axiom.ts.soap.header.TestExamineHeaderBlocks;
import org.apache.axiom.ts.soap.header.TestExamineHeaderBlocksWithParser;
import org.apache.axiom.ts.soap.header.TestExamineMustUnderstandHeaderBlocksWithParser;
import org.apache.axiom.ts.soap.header.TestExtractAllHeaderBlocks;
import org.apache.axiom.ts.soap.header.TestGetHeaderBlocksWithNSURI;
import org.apache.axiom.ts.soap.header.TestGetHeaderBlocksWithNSURIWithParser;
import org.apache.axiom.ts.soap.header.TestGetHeadersToProcessWithNamespace;
import org.apache.axiom.ts.soap.header.TestGetHeadersToProcessWithParser;
import org.apache.axiom.ts.soap.headerblock.TestByteArrayDS;
import org.apache.axiom.ts.soap.headerblock.TestCloneProcessedWithoutPreservingModel;
import org.apache.axiom.ts.soap.headerblock.TestGetBooleanAttribute;
import org.apache.axiom.ts.soap.headerblock.TestGetBooleanAttributeDefault;
import org.apache.axiom.ts.soap.headerblock.TestGetBooleanAttributeInvalid;
import org.apache.axiom.ts.soap.headerblock.TestGetBooleanAttributeUnspported;
import org.apache.axiom.ts.soap.headerblock.TestGetRole;
import org.apache.axiom.ts.soap.headerblock.TestGetVersion;
import org.apache.axiom.ts.soap.headerblock.TestSetBooleanAttribute;
import org.apache.axiom.ts.soap.headerblock.TestSetBooleanAttributeUnsupported;
import org.apache.axiom.ts.soap.headerblock.TestSetMustUnderstandString;
import org.apache.axiom.ts.soap.headerblock.TestSetMustUnderstandWithInvalidValue;
import org.apache.axiom.ts.soap.headerblock.TestSetRole;
import org.apache.axiom.ts.soap.headerblock.TestSetRoleWithoutExistingNamespaceDecl;
import org.apache.axiom.ts.soap.message.TestClone;
import org.apache.axiom.ts.soap.message.TestCloneIncomplete;
import org.apache.axiom.ts.soap.message.TestGetCharsetEncodingWithParser;
import org.apache.axiom.ts.soap.message.TestGetOMFactoryWithParser;
import org.apache.axiom.ts.soap.message.TestSerialize;
import org.apache.axiom.ts.soap.message.TestSetOMDocumentElement;
import org.apache.axiom.ts.soap.message.TestSetOMDocumentElementNonSOAPEnvelope;
import org.apache.axiom.ts.soap.misc.TestGetChild;
import org.apache.axiom.ts.soap.misc.TestSetChild;
import org.apache.axiom.ts.soap.misc.TestSetChildVersionMismatch;
import org.apache.axiom.ts.soap.xpath.TestXPathAppliedToSOAPEnvelope;
import org.apache.axiom.ts.soap11.builder.TestBuilder;
import org.apache.axiom.ts.soap11.fault.TestGetNode;
import org.apache.axiom.ts.soap11.faultcode.TestGetValue;
import org.apache.axiom.ts.soap11.faultcode.TestSetValueFromQName;
import org.apache.axiom.ts.soap11.faultreason.TestAddSOAPText;
import org.apache.axiom.ts.soap11.faultreason.TestGetFirstSOAPText;
import org.apache.axiom.ts.soap11.faultreason.TestGetTextWithCDATA;
import org.apache.axiom.ts.soap11.misc.TestElementPullStreamAndOMExpansion;
import org.apache.axiom.ts.soap11.misc.TestElementPullStreamAndOMExpansion2;
import org.apache.axiom.ts.soap11.misc.TestElementPullStreamAndOMExpansion3;
import org.apache.axiom.ts.soap12.envelope.TestBuildWithAttachments;
import org.apache.axiom.ts.soap12.envelope.TestMTOMForwardStreaming;
import org.apache.axiom.ts.soap12.factory.TestCreateSOAPFaultSubCode;
import org.apache.axiom.ts.soap12.fault.TestGetNodeWithParser;
import org.apache.axiom.ts.soap12.fault.TestMoreChildrenAddition;
import org.apache.axiom.ts.soap12.fault.TestSetNode;
import org.apache.axiom.ts.soap12.faultcode.TestGetSubCodeWithParser;
import org.apache.axiom.ts.soap12.faultcode.TestGetValueWithParser;
import org.apache.axiom.ts.soap12.faultcode.TestSetValueFromQNameWithExistingValue;
import org.apache.axiom.ts.soap12.faultreason.TestAddSOAPTextMultiple;
import org.apache.axiom.ts.soap12.faultreason.TestAddSOAPTextWithSOAPVersionMismatch;
import org.apache.axiom.ts.soap12.faultreason.TestGetFirstSOAPTextWithParser;
import org.apache.axiom.ts.soap12.faultsubcode.TestGetSubCodeNestedWithParser;
import org.apache.axiom.ts.soap12.faultsubcode.TestGetValueAsQNameWithParser;
import org.apache.axiom.ts.soap12.faultsubcode.TestGetValueNestedWithParser;
import org.apache.axiom.ts.soap12.faulttext.TestGetLangWithParser;
import org.apache.axiom.ts.soap12.header.TestExamineMustUnderstandHeaderBlocks;
import org.apache.axiom.ts.soap12.headerblock.TestGetMustUnderstandWithParser;
import org.apache.axiom.ts.soap12.headerblock.TestGetRelayWithParser;
import org.apache.axiom.ts.soap12.headerblock.TestGetRoleWithParser;
import org.apache.axiom.ts.soap12.mtom.TestBuilderDetach;
import org.apache.axiom.ts.soap12.mtom.TestGetXMLStreamReaderMTOMEncoded;

public class SOAPTestSuiteBuilder
extends MatrixTestSuiteBuilder {
    private static final String[] badSOAPFiles = new String[]{"wrongSoapNs.xml", "notnamespaceQualified.xml", "soap11/twoheaders.xml", "soap11/twoBodymessage.xml", "soap11/envelopeMissing.xml", "soap11/haederBodyWrongOrder.xml", "soap11/invalid-faultcode.xml", "soap11/invalid-faultstring.xml", "soap11/invalid-faultactor.xml", "soap11/processing-instruction.xml", "soap11/entity-reference.xml", "soap12/header-bad-case.xml", "soap12/header-no-namespace.xml", "soap12/processing-instruction.xml", "soap12/entity-reference.xml", "soap12/additional-element-after-body.xml"};
    private static final List<SOAPSample> goodSOAPFiles = new ArrayList<SOAPSample>();
    private static final QName[] generalQNames;
    private static final QName[] noFaultQNames;
    private final OMMetaFactory metaFactory;
    private final boolean supportsOMSourcedElement;
    private final boolean supportsBodyElementNameOptimization;

    public SOAPTestSuiteBuilder(OMMetaFactory metaFactory, boolean supportsOMSourcedElement, boolean supportsBodyElementNameOptimization) {
        this.metaFactory = metaFactory;
        this.supportsOMSourcedElement = supportsOMSourcedElement;
        this.supportsBodyElementNameOptimization = supportsBodyElementNameOptimization;
    }

    private void addTests(SOAPSpec spec) {
        int i;
        QName qname;
        int i2;
        BooleanLiteral[] booleanLiterals = spec.getBooleanLiterals();
        String[] invalidBooleanLiterals = spec.getInvalidBooleanLiterals();
        this.addTest(new TestAddFault1(this.metaFactory, spec));
        this.addTest(new TestAddFault2(this.metaFactory, spec));
        this.addTest(new TestCloneOMElement(this.metaFactory, spec));
        this.addTest(new TestGetFault(this.metaFactory, spec));
        this.addTest(new TestGetFaultFakeFault(this.metaFactory, spec));
        this.addTest(new TestGetFaultWithParser(this.metaFactory, spec));
        for (i2 = 0; i2 < generalQNames.length; ++i2) {
            qname = generalQNames[i2];
            this.addTest(new TestGetFirstElementLocalNameWithParser(this.metaFactory, spec, qname, this.supportsBodyElementNameOptimization));
            this.addTest(new TestGetFirstElementNSWithParser(this.metaFactory, spec, qname, this.supportsBodyElementNameOptimization));
        }
        this.addTest(new TestGetFirstElementLocalNameWithParser2(this.metaFactory, spec, false));
        this.addTest(new TestGetFirstElementLocalNameWithParser2(this.metaFactory, spec, true));
        this.addTest(new TestGetFirstElementLocalNameWithParserNoLookahead(this.metaFactory, spec));
        for (i2 = 0; i2 < noFaultQNames.length; ++i2) {
            qname = noFaultQNames[i2];
            this.addTest(new TestGetFaultNoFault(this.metaFactory, spec, qname));
            this.addTest(new TestGetFaultWithParserNoFault(this.metaFactory, spec, qname));
            this.addTest(new TestHasFaultNoFault(this.metaFactory, spec, qname));
            this.addTest(new TestHasFaultWithParserNoFault(this.metaFactory, spec, qname, this.supportsBodyElementNameOptimization));
        }
        this.addTest(new TestGetFirstElementLocalNameEmptyBody(this.metaFactory, spec));
        this.addTest(new TestGetFirstElementNSEmptyBody(this.metaFactory, spec));
        this.addTest(new TestHasFault(this.metaFactory, spec));
        this.addTest(new TestHasFaultAfterReplace(this.metaFactory, spec));
        this.addTest(new TestHasFaultFakeFault(this.metaFactory, spec));
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestHasFaultWithOMSEUnknownName(this.metaFactory, spec));
        }
        this.addTest(new org.apache.axiom.ts.soap.body.TestHasFaultWithParser(this.metaFactory, spec));
        this.addTest(new TestCommentInEpilog(this.metaFactory, spec));
        this.addTest(new TestCommentInProlog(this.metaFactory, spec));
        this.addTest(new TestCreateSOAPModelBuilderFromDOMSource(this.metaFactory, spec));
        this.addTest(new TestCreateSOAPModelBuilderMTOMContentTypeMismatch(this.metaFactory, spec));
        this.addTest(new TestDTD(this.metaFactory, spec));
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestRegisterCustomBuilder(this.metaFactory, spec));
            if (this.supportsBodyElementNameOptimization) {
                this.addTest(new TestRegisterCustomBuilderForPayloadAfterSOAPFaultCheck(this.metaFactory, spec));
            }
        }
        this.addTest(new TestAddElementAfterBody(this.metaFactory, spec, false));
        this.addTest(new TestAddElementAfterBody(this.metaFactory, spec, true));
        this.addTest(new TestAddHeaderToIncompleteEnvelope(this.metaFactory, spec));
        this.addTest(new TestBodyHeaderOrder(this.metaFactory, spec));
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestCloneWithSourcedElement1(this.metaFactory, spec));
            this.addTest(new TestCloneWithSourcedElement2(this.metaFactory, spec));
        }
        this.addTest(new TestDetach(this.metaFactory, spec));
        this.addTest(new TestGetBody(this.metaFactory, spec));
        this.addTest(new TestGetBodyOnEmptyEnvelope(this.metaFactory, spec));
        this.addTest(new TestGetBodyOnEnvelopeWithHeaderOnly(this.metaFactory, spec));
        this.addTest(new TestGetBodyWithParser(this.metaFactory, spec));
        this.addTest(new TestGetHeader(this.metaFactory, spec));
        this.addTest(new TestGetHeaderWithParser(this.metaFactory, spec));
        this.addTest(new TestGetHeaderWithParserNoHeader(this.metaFactory, spec));
        this.addTest(new TestGetOrCreateHeader(this.metaFactory, spec));
        this.addTest(new TestGetOrCreateHeaderWithParserNoHeader(this.metaFactory, spec));
        for (i2 = 0; i2 < generalQNames.length; ++i2) {
            qname = generalQNames[i2];
            this.addTest(new TestGetSOAPBodyFirstElementLocalNameAndNS(this.metaFactory, spec, qname));
            this.addTest(new TestGetSOAPBodyFirstElementLocalNameAndNSWithParser(this.metaFactory, spec, qname));
        }
        this.addTest(new TestGetXMLStreamReaderWithoutCachingWithPartiallyBuiltHeaderBlock(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.envelope.TestHasFault(this.metaFactory, spec));
        this.addTest(new TestHasFaultWithParser(this.metaFactory, spec));
        this.addTest(new TestHasFaultWithParserOptimized(this.metaFactory, spec));
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestSerializeAndConsumeWithOMSEInBody(this.metaFactory, spec));
        }
        this.addTest(new TestCreateDefaultSOAPMessage(this.metaFactory, spec));
        this.addTest(new TestCreateSOAPEnvelopeWithCustomPrefix(this.metaFactory, spec));
        SOAPElementType[] arr$ = SOAPElementType.getAll();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            SOAPElementType type = arr$[i$];
            this.addTest(new TestCreateSOAPElement(this.metaFactory, spec, type));
            for (SOAPElementType childType : type.getChildTypes()) {
                this.addTest(new TestCreateSOAPElementWithNullParent(this.metaFactory, spec, childType, type));
                if (type.getQName(spec) == null) continue;
                this.addTest(new TestCreateSOAPElementWithParent(this.metaFactory, spec, childType, type));
            }
        }
        this.addTest(new TestCreateSOAPFaultWithException(this.metaFactory, spec, true));
        this.addTest(new TestCreateSOAPFaultWithException(this.metaFactory, spec, false));
        this.addTest(new TestFactoryIsSingleton(this.metaFactory, spec));
        this.addTest(new TestGetDefaultEnvelope(this.metaFactory, spec));
        this.addTest(new TestGetDefaultFaultEnvelope(this.metaFactory, spec));
        this.addTest(new TestGetMetaFactory(this.metaFactory, spec));
        this.addTest(new TestGetNamespace(this.metaFactory, spec));
        for (SerializationStrategy ss : Multiton.getInstances(SerializationStrategy.class)) {
            this.addTest(new TestChildOrder(this.metaFactory, spec, new SOAPFaultChild[]{SOAPFaultChild.REASON, SOAPFaultChild.CODE}, ss));
            this.addTest(new TestChildOrder(this.metaFactory, spec, new SOAPFaultChild[]{SOAPFaultChild.CODE, SOAPFaultChild.REASON, SOAPFaultChild.DETAIL, SOAPFaultChild.REASON}, ss));
        }
        this.addTest(new TestGetCodeWithParser(this.metaFactory, spec));
        this.addTest(new TestGetDetailWithParser(this.metaFactory, spec));
        this.addTest(new TestGetException(this.metaFactory, spec));
        this.addTest(new TestGetReasonWithParser(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.fault.TestGetRoleWithParser(this.metaFactory, spec));
        this.addTest(new TestSetException(this.metaFactory, spec));
        this.addTest(new TestWrongParent1(this.metaFactory, spec));
        this.addTest(new TestWrongParent2(this.metaFactory, spec));
        this.addTest(new TestWrongParent3(this.metaFactory, spec));
        this.addTest(new TestGetValueAsQName(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.faultcode.TestGetValueAsQNameWithParser(this.metaFactory, spec));
        this.addTest(new TestAddDetailEntry(this.metaFactory, spec));
        this.addTest(new TestDetailEntriesUsingDefaultNamespaceWithParser(this.metaFactory, spec));
        this.addTest(new TestGetAllDetailEntries(this.metaFactory, spec));
        this.addTest(new TestGetAllDetailEntriesWithParser(this.metaFactory, spec));
        this.addTest(new TestSerialization(this.metaFactory, spec));
        this.addTest(new TestWSCommons202(this.metaFactory, spec));
        if (spec.getFaultTextQName() != null) {
            this.addTest(new TestGetLang(this.metaFactory, spec));
            this.addTest(new TestGetLangFromParser(this.metaFactory, spec));
            this.addTest(new TestSetLang(this.metaFactory, spec));
        }
        if (spec.getFaultNodeQName() != null) {
            this.addTest(new TestGetFaultNodeValue(this.metaFactory, spec));
            this.addTest(new TestGetFaultNodeValueWithParser(this.metaFactory, spec));
            this.addTest(new TestSetFaultNodeValue(this.metaFactory, spec));
        }
        this.addTest(new TestGetRoleValue(this.metaFactory, spec));
        this.addTest(new TestGetRoleValueWithParser(this.metaFactory, spec));
        this.addTest(new TestSetRoleValue(this.metaFactory, spec));
        this.addTest(new TestAddHeaderBlock(this.metaFactory, spec));
        this.addTest(new TestAddHeaderBlockFromQName(this.metaFactory, spec));
        this.addTest(new TestAddHeaderBlockFromQNameWithoutNamespace(this.metaFactory, spec));
        this.addTest(new TestAddHeaderBlockWithoutNamespace1(this.metaFactory, spec));
        this.addTest(new TestAddHeaderBlockWithoutNamespace2(this.metaFactory, spec));
        this.addTest(new TestDiscardIncomplete(this.metaFactory, spec));
        this.addTest(new TestDiscardPartiallyBuilt(this.metaFactory, spec));
        this.addTest(new TestExamineAllHeaderBlocks(this.metaFactory, spec));
        this.addTest(new TestExamineAllHeaderBlocksWithParser(this.metaFactory, spec));
        this.addTest(new TestExamineHeaderBlocks(this.metaFactory, spec));
        this.addTest(new TestExamineHeaderBlocksWithParser(this.metaFactory, spec));
        this.addTest(new TestExamineMustUnderstandHeaderBlocksWithParser(this.metaFactory, spec));
        this.addTest(new TestExtractAllHeaderBlocks(this.metaFactory, spec));
        this.addTest(new TestGetHeaderBlocksWithNSURI(this.metaFactory, spec));
        this.addTest(new TestGetHeaderBlocksWithNSURIWithParser(this.metaFactory, spec));
        this.addTest(new TestGetHeadersToProcessWithNamespace(this.metaFactory, spec));
        this.addTest(new TestGetHeadersToProcessWithParser(this.metaFactory, spec));
        for (HeaderBlockAttribute attribute : Multiton.getInstances(HeaderBlockAttribute.class)) {
            if (!attribute.isBoolean()) continue;
            if (attribute.isSupported(spec)) {
                int j;
                for (j = 0; j < booleanLiterals.length; ++j) {
                    this.addTest(new TestGetBooleanAttribute(this.metaFactory, spec, attribute, booleanLiterals[j]));
                }
                this.addTest(new TestGetBooleanAttributeDefault(this.metaFactory, spec, attribute));
                for (j = 0; j < invalidBooleanLiterals.length; ++j) {
                    this.addTest(new TestGetBooleanAttributeInvalid(this.metaFactory, spec, attribute, invalidBooleanLiterals[j]));
                }
                this.addTest(new TestSetBooleanAttribute(this.metaFactory, spec, attribute, true));
                this.addTest(new TestSetBooleanAttribute(this.metaFactory, spec, attribute, false));
                continue;
            }
            this.addTest(new TestGetBooleanAttributeUnspported(this.metaFactory, spec, attribute));
            this.addTest(new TestSetBooleanAttributeUnsupported(this.metaFactory, spec, attribute));
        }
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestByteArrayDS(this.metaFactory, spec));
        }
        this.addTest(new org.apache.axiom.ts.soap.headerblock.TestClone(this.metaFactory, spec, Boolean.TRUE));
        this.addTest(new org.apache.axiom.ts.soap.headerblock.TestClone(this.metaFactory, spec, Boolean.FALSE));
        this.addTest(new org.apache.axiom.ts.soap.headerblock.TestClone(this.metaFactory, spec, null));
        this.addTest(new TestCloneProcessedWithoutPreservingModel(this.metaFactory, spec));
        this.addTest(new TestGetRole(this.metaFactory, spec));
        this.addTest(new TestGetVersion(this.metaFactory, spec));
        for (i = 0; i < booleanLiterals.length; ++i) {
            this.addTest(new TestSetMustUnderstandString(this.metaFactory, spec, booleanLiterals[i]));
        }
        for (i = 0; i < invalidBooleanLiterals.length; ++i) {
            this.addTest(new TestSetMustUnderstandWithInvalidValue(this.metaFactory, spec, invalidBooleanLiterals[i]));
        }
        this.addTest(new TestSetRole(this.metaFactory, spec));
        this.addTest(new TestSetRoleWithoutExistingNamespaceDecl(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.headerblock.TestWrongParent1(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.headerblock.TestWrongParent2(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.headerblock.TestWrongParent3(this.metaFactory, spec));
        this.addTest(new TestClone(this.metaFactory, spec, true));
        this.addTest(new TestClone(this.metaFactory, spec, false));
        this.addTest(new TestCloneIncomplete(this.metaFactory, spec, true));
        this.addTest(new TestCloneIncomplete(this.metaFactory, spec, false));
        this.addTest(new TestGetCharsetEncodingWithParser(this.metaFactory, spec));
        this.addTest(new TestGetOMFactoryWithParser(this.metaFactory, spec));
        this.addTest(new TestSetOMDocumentElement(this.metaFactory, spec));
        this.addTest(new TestSetOMDocumentElementNonSOAPEnvelope(this.metaFactory, spec));
        for (SOAPElementType type : SOAPElementType.getAll()) {
            if (type.getQName(spec) == null) continue;
            for (SOAPElementType childType : type.getChildTypes()) {
                if (childType.getQName(spec) == null) continue;
                if (((SOAPElementTypeAdapter)childType.getAdapter(SOAPElementTypeAdapter.class)).getGetter() != null) {
                    this.addTest(new TestGetChild(this.metaFactory, spec, type, childType));
                }
                if (((SOAPElementTypeAdapter)childType.getAdapter(SOAPElementTypeAdapter.class)).getSetter() == null) continue;
                this.addTest(new TestSetChild(this.metaFactory, spec, type, childType));
                if (childType.getQName(spec.getAltSpec()) == null) continue;
                this.addTest(new TestSetChildVersionMismatch(this.metaFactory, spec, type, childType));
            }
        }
        this.addTest(new TestXPathAppliedToSOAPEnvelope(this.metaFactory, spec, true));
        this.addTest(new TestXPathAppliedToSOAPEnvelope(this.metaFactory, spec, false));
    }

    protected void addTests() {
        this.addTests(SOAPSpec.SOAP11);
        this.addTests(SOAPSpec.SOAP12);
        for (int i = 0; i < badSOAPFiles.length; ++i) {
            this.addTest(new BadInputTest(this.metaFactory, badSOAPFiles[i]));
        }
        for (SOAPSample msg : goodSOAPFiles) {
            this.addTest(new MessageTest(this.metaFactory, msg));
            if (this.supportsOMSourcedElement) {
                this.addTest(new TestRegisterCustomBuilderForPayload(this.metaFactory, msg));
            }
            this.addTest(new org.apache.axiom.ts.soap.envelope.TestClone(this.metaFactory, msg));
            for (ExpansionStrategy expansionStrategy : Multiton.getInstances(ExpansionStrategy.class)) {
                for (SerializationStrategy serializationStrategy : Multiton.getInstances(SerializationStrategy.class)) {
                    this.addTest(new org.apache.axiom.ts.soap.envelope.TestSerialize(this.metaFactory, msg, expansionStrategy, serializationStrategy));
                    this.addTest(new TestSerialize(this.metaFactory, msg, expansionStrategy, serializationStrategy));
                }
            }
        }
        this.addTest(new TestBuilder(this.metaFactory));
        this.addTest(new TestGetNode(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap11.fault.TestSetNode(this.metaFactory));
        this.addTest(new TestGetValue(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap11.faultcode.TestGetValueWithParser(this.metaFactory));
        this.addTest(new TestSetValueFromQName(this.metaFactory));
        this.addTest(new TestAddSOAPText(this.metaFactory));
        this.addTest(new TestGetFirstSOAPText(this.metaFactory));
        this.addTest(new TestGetTextWithCDATA(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap11.headerblock.TestGetMustUnderstandWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap11.headerblock.TestGetRoleWithParser(this.metaFactory));
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestElementPullStreamAndOMExpansion(this.metaFactory));
            this.addTest(new TestElementPullStreamAndOMExpansion2(this.metaFactory));
            this.addTest(new TestElementPullStreamAndOMExpansion3(this.metaFactory));
        }
        this.addTest(new org.apache.axiom.ts.soap12.builder.TestBuilder(this.metaFactory));
        this.addTest(new TestBuildWithAttachments(this.metaFactory));
        this.addTest(new TestMTOMForwardStreaming(this.metaFactory, true));
        this.addTest(new TestMTOMForwardStreaming(this.metaFactory, false));
        this.addTest(new TestCreateSOAPFaultSubCode(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.fault.TestGetNode(this.metaFactory));
        this.addTest(new TestGetNodeWithParser(this.metaFactory));
        this.addTest(new TestMoreChildrenAddition(this.metaFactory));
        this.addTest(new TestSetNode(this.metaFactory));
        this.addTest(new TestGetSubCodeWithParser(this.metaFactory));
        this.addTest(new TestGetValueWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultcode.TestSetValueFromQName(this.metaFactory));
        this.addTest(new TestSetValueFromQNameWithExistingValue(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultreason.TestAddSOAPText(this.metaFactory));
        this.addTest(new TestAddSOAPTextMultiple(this.metaFactory));
        this.addTest(new TestAddSOAPTextWithSOAPVersionMismatch(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultreason.TestGetFirstSOAPText(this.metaFactory));
        this.addTest(new TestGetFirstSOAPTextWithParser(this.metaFactory));
        this.addTest(new TestGetSubCodeNestedWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultsubcode.TestGetSubCodeWithParser(this.metaFactory));
        this.addTest(new TestGetValueNestedWithParser(this.metaFactory));
        this.addTest(new TestGetValueAsQNameWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultsubcode.TestGetValueWithParser(this.metaFactory));
        this.addTest(new TestGetLangWithParser(this.metaFactory));
        this.addTest(new TestExamineMustUnderstandHeaderBlocks(this.metaFactory));
        this.addTest(new TestGetMustUnderstandWithParser(this.metaFactory));
        this.addTest(new TestGetRelayWithParser(this.metaFactory));
        this.addTest(new TestGetRoleWithParser(this.metaFactory));
        this.addTest(new TestBuilderDetach(this.metaFactory));
        this.addTest(new TestGetXMLStreamReaderMTOMEncoded(this.metaFactory, true));
        this.addTest(new TestGetXMLStreamReaderMTOMEncoded(this.metaFactory, false));
    }

    static {
        goodSOAPFiles.addAll(Arrays.asList(new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/whitespacedMessage.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/minimalMessage.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/reallyReallyBigMessage.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/emtyBodymessage.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/soapfault.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/soapfault2.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/bodyNotQualified.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/message.xml"), new SimpleSOAPSample(SOAPSpec.SOAP12, "soap/soap12/message.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/faultelements-with-comment.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/additional-element-after-body.xml"), new SimpleSOAPSample(SOAPSpec.SOAP11, "soap/soap11/empty-header.xml"), new SimpleSOAPSample(SOAPSpec.SOAP12, "soap/soap12/empty-header.xml")));
        goodSOAPFiles.addAll(Multiton.getInstances(SOAPSample.class));
        generalQNames = new QName[]{new QName("root"), new QName("urn:test", "root", "p"), new QName("urn:test", "root")};
        noFaultQNames = new QName[]{new QName("root"), new QName("urn:test", "root", "p"), new QName("urn:test", "root"), new QName("Fault"), new QName("urn:test", "Fault", "p"), new QName("http://schemas.xmlsoap.org/soap/envelope/", "NoFault", "soapenv"), new QName("http://www.w3.org/2003/05/soap-envelope", "NoFault", "soapenv")};
    }
}

