/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.mime.ContentTypeBuilder;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.ts.soap.SOAPSample;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;
import org.apache.axiom.util.UIDGenerator;

public class TestCreateSOAPModelBuilderMTOMContentTypeMismatch
extends SOAPTestCase {
    public TestCreateSOAPModelBuilderMTOMContentTypeMismatch(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        final SOAPSample sample = SOAPSampleSet.NO_HEADER.getMessage(this.spec);
        MimeMessage message = new MimeMessage((Session)null);
        MimeMultipart mp = new MimeMultipart("related");
        MimeBodyPart bp = new MimeBodyPart();
        String contentID = "<" + UIDGenerator.generateContentId() + ">";
        bp.setDataHandler(new DataHandler(new DataSource(){

            public String getContentType() {
                return "application/xop+xml; charset=\"" + sample.getEncoding() + "\"; type=\"" + TestCreateSOAPModelBuilderMTOMContentTypeMismatch.this.spec.getAltSpec().getContentType() + "\"";
            }

            public InputStream getInputStream() throws IOException {
                return sample.getInputStream();
            }

            public String getName() {
                return null;
            }

            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }
        }));
        bp.addHeader("Content-Transfer-Encoding", "binary");
        bp.addHeader("Content-ID", contentID);
        mp.addBodyPart((BodyPart)bp);
        message.setContent((Multipart)mp);
        message.saveChanges();
        ContentTypeBuilder contentType = new ContentTypeBuilder(message.getContentType());
        contentType.setParameter("type", "application/xop+xml");
        contentType.setParameter("start", contentID);
        contentType.setParameter("start-info", this.spec.getAltSpec().getContentType());
        MemoryBlob blob = Blobs.createMemoryBlob();
        OutputStream out = blob.getOutputStream();
        mp.writeTo(out);
        out.close();
        try {
            OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Attachments)new Attachments(blob.getInputStream(), contentType.toString()));
            TestCreateSOAPModelBuilderMTOMContentTypeMismatch.fail((String)"Expected SOAPProcessingException");
        }
        catch (SOAPProcessingException ex) {
            // empty catch block
        }
    }
}

