/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.factory;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.soap.SOAPElementType;
import org.apache.axiom.ts.soap.SOAPElementTypeAdapter;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public abstract class CreateSOAPElementWithoutParentTestCase
extends SOAPTestCase {
    protected final SOAPElementType type;

    public CreateSOAPElementWithoutParentTestCase(OMMetaFactory metaFactory, SOAPSpec spec, SOAPElementType type) {
        super(metaFactory, spec);
        this.type = type;
        ((SOAPElementTypeAdapter)type.getAdapter(SOAPElementTypeAdapter.class)).addTestParameters(this);
    }

    protected final void runTest() throws Throwable {
        QName expectedName = this.type.getQName(this.spec);
        if (expectedName == null) {
            try {
                this.createSOAPElement();
                CreateSOAPElementWithoutParentTestCase.fail((String)"Expect UnsupportedOperationException");
            }
            catch (UnsupportedOperationException ex) {}
        } else {
            String expectedPrefix = expectedName.getNamespaceURI().length() == 0 ? "" : "soapenv";
            OMElement element = this.createSOAPElement();
            CreateSOAPElementWithoutParentTestCase.assertTrue((boolean)element.isComplete());
            QName actualName = element.getQName();
            CreateSOAPElementWithoutParentTestCase.assertEquals((Object)expectedName, (Object)actualName);
            CreateSOAPElementWithoutParentTestCase.assertEquals((String)expectedPrefix, (String)actualName.getPrefix());
            CreateSOAPElementWithoutParentTestCase.assertNull((Object)element.getParent());
            Iterator it = element.getAllDeclaredNamespaces();
            if (expectedPrefix.length() != 0) {
                CreateSOAPElementWithoutParentTestCase.assertTrue((boolean)it.hasNext());
                OMNamespace ns = (OMNamespace)it.next();
                CreateSOAPElementWithoutParentTestCase.assertEquals((String)expectedName.getNamespaceURI(), (String)ns.getNamespaceURI());
                CreateSOAPElementWithoutParentTestCase.assertEquals((String)expectedPrefix, (String)ns.getPrefix());
            }
            CreateSOAPElementWithoutParentTestCase.assertFalse((boolean)it.hasNext());
            CreateSOAPElementWithoutParentTestCase.assertFalse((boolean)element.getAllAttributes().hasNext());
            CreateSOAPElementWithoutParentTestCase.assertNull((Object)element.getFirstOMChild());
        }
    }

    protected abstract OMElement createSOAPElement();
}

