/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.factory;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.ts.soap.SOAPElementType;
import org.apache.axiom.ts.soap.SOAPElementTypeAdapter;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestCreateSOAPElementWithParent
extends SOAPTestCase {
    private final SOAPElementType type;
    private final SOAPElementType parentType;

    public TestCreateSOAPElementWithParent(OMMetaFactory metaFactory, SOAPSpec spec, SOAPElementType type, SOAPElementType parentType) {
        super(metaFactory, spec);
        this.type = type;
        this.parentType = parentType;
        this.addTestParameter("type", ((SOAPElementTypeAdapter)type.getAdapter(SOAPElementTypeAdapter.class)).getType().getSimpleName());
        this.addTestParameter("parentType", ((SOAPElementTypeAdapter)parentType.getAdapter(SOAPElementTypeAdapter.class)).getType().getSimpleName());
    }

    protected void runTest() throws Throwable {
        OMElement parent = ((SOAPElementTypeAdapter)this.parentType.getAdapter(SOAPElementTypeAdapter.class)).create(this.soapFactory);
        QName expectedName = this.type.getQName(this.spec);
        if (expectedName == null) {
            try {
                ((SOAPElementTypeAdapter)this.type.getAdapter(SOAPElementTypeAdapter.class)).create(this.soapFactory, this.parentType, parent);
                TestCreateSOAPElementWithParent.fail((String)"Expect UnsupportedOperationException");
            }
            catch (UnsupportedOperationException ex) {}
        } else {
            String expectedPrefix = expectedName.getNamespaceURI().length() == 0 ? "" : "soapenv";
            OMElement child = ((SOAPElementTypeAdapter)this.type.getAdapter(SOAPElementTypeAdapter.class)).create(this.soapFactory, this.parentType, parent);
            TestCreateSOAPElementWithParent.assertTrue((boolean)child.isComplete());
            QName actualName = child.getQName();
            TestCreateSOAPElementWithParent.assertEquals((Object)expectedName, (Object)actualName);
            TestCreateSOAPElementWithParent.assertEquals((String)expectedPrefix, (String)actualName.getPrefix());
            TestCreateSOAPElementWithParent.assertSame((Object)parent, (Object)child.getParent());
            TestCreateSOAPElementWithParent.assertSame((Object)child, (Object)parent.getFirstOMChild());
            TestCreateSOAPElementWithParent.assertNull((Object)child.getNextOMSibling());
            TestCreateSOAPElementWithParent.assertFalse((boolean)child.getAllDeclaredNamespaces().hasNext());
            TestCreateSOAPElementWithParent.assertFalse((boolean)child.getAllAttributes().hasNext());
            TestCreateSOAPElementWithParent.assertNull((Object)child.getFirstOMChild());
        }
    }
}

