/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.factory;

import com.google.common.truth.Truth;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestCreateSOAPFaultWithException
extends SOAPTestCase {
    private final boolean withParent;

    public TestCreateSOAPFaultWithException(OMMetaFactory metaFactory, SOAPSpec spec, boolean withParent) {
        super(metaFactory, spec);
        this.withParent = withParent;
        this.addTestParameter("withParent", withParent);
    }

    protected void runTest() throws Throwable {
        SOAPBody body = this.withParent ? this.soapFactory.getDefaultEnvelope().getBody() : null;
        SOAPFault fault = this.soapFactory.createSOAPFault(body, new Exception("Testing soap fault"));
        if (body != null) {
            Truth.assertThat((Boolean)body.hasFault()).isTrue();
            Truth.assertThat((Object)body.getFault()).isSameAs((Object)fault);
        }
        Truth.assertThat((Boolean)fault.isComplete()).isTrue();
        SOAPFaultDetail detail = fault.getDetail();
        Truth.assertThat((Object)detail).isNotNull();
        Iterator it = detail.getAllDetailEntries();
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        OMElement entry = (OMElement)it.next();
        Truth.assertThat((Object)entry.getQName()).isEqualTo((Object)new QName("Exception"));
        Truth.assertThat((String)entry.getText()).contains((CharSequence)"Testing soap fault");
    }
}

