/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.mtom;

import com.google.common.truth.Truth;
import java.io.InputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.testutils.io.InstrumentedInputStream;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.soap.MTOMSample;

public class TestBuilderDetach
extends AxiomTestCase {
    public TestBuilderDetach(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        MTOMSample sample = MTOMSample.SAMPLE1;
        InstrumentedInputStream in = new InstrumentedInputStream(sample.getInputStream());
        Attachments attachments = new Attachments((InputStream)in, sample.getContentType());
        SOAPModelBuilder builder = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Attachments)attachments);
        SOAPEnvelope envelope = builder.getSOAPEnvelope();
        long countBeforeDetach = in.getCount();
        builder.detach();
        Truth.assertThat((Long)in.getCount()).isGreaterThan((Comparable)Long.valueOf(countBeforeDetach));
        Truth.assertThat((Boolean)in.isClosed()).isFalse();
        int binaryCount = 0;
        Iterator it = envelope.getDescendants(false);
        while (it.hasNext()) {
            OMText text;
            OMNode node = (OMNode)it.next();
            if (!(node instanceof OMText) || !(text = (OMText)node).isBinary()) continue;
            IOTestUtils.compareStreams((InputStream)sample.getPart(text.getContentID()), (InputStream)((DataHandler)text.getDataHandler()).getInputStream());
            ++binaryCount;
        }
        Truth.assertThat((Integer)binaryCount).isGreaterThan((Comparable)Integer.valueOf(0));
        in.close();
    }
}

