/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension.serialization;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.dimension.serialization.SAXSerializer;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.dimension.serialization.XML;
import org.apache.axiom.ts.dimension.serialization.XMLAsByteArray;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLReader;

public class SerializeFromSAXSource
extends SerializationStrategy {
    private final boolean cache;

    SerializeFromSAXSource(boolean cache) {
        this.cache = cache;
    }

    public void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("serializationStrategy", "SAXSource");
        testCase.addTestParameter("cache", this.cache);
    }

    @Override
    public XML serialize(OMContainer container) throws Exception {
        SAXSource source = container.getSAXSource(this.cache);
        XMLReader xmlReader = source.getXMLReader();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SAXSerializer serializer = new SAXSerializer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputStream(out);
        xmlReader.setContentHandler((ContentHandler)((Object)serializer));
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)serializer);
        xmlReader.parse(source.getInputSource());
        return new XMLAsByteArray(out.toByteArray());
    }

    @Override
    public boolean isPush() {
        return true;
    }

    @Override
    public boolean isCaching() {
        return this.cache;
    }

    @Override
    public boolean supportsInternalSubset() {
        return false;
    }
}

