/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.ts.om.builder.AttachmentUnmarshallerImpl;
import org.apache.axiom.util.stax.xop.XOPEncodedStream;
import org.apache.axiom.util.stax.xop.XOPUtils;
import org.junit.Assert;

public class JAXBCustomBuilder
implements CustomBuilder {
    private final JAXBContext jaxbContext;
    private final boolean expectBareReader;
    private Object jaxbObject;
    private boolean attachmentsAccessed;

    public JAXBCustomBuilder(JAXBContext jaxbContext, boolean expectBareReader) {
        this.jaxbContext = jaxbContext;
        this.expectBareReader = expectBareReader;
    }

    public OMElement create(String namespaceURI, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory) throws OMException {
        try {
            XOPEncodedStream xopStream = XOPUtils.getXOPEncodedStream((XMLStreamReader)reader);
            XMLStreamReader encodedReader = xopStream.getReader();
            if (this.expectBareReader) {
                String className = encodedReader.getClass().getName();
                Assert.assertTrue((!className.startsWith("org.apache.axiom.") || className.startsWith("org.apache.axiom.util.stax.dialect.") ? 1 : 0) != 0);
            }
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            AttachmentUnmarshallerImpl attachmentUnmarshaller = new AttachmentUnmarshallerImpl(xopStream.getMimePartProvider());
            unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)attachmentUnmarshaller);
            this.jaxbObject = unmarshaller.unmarshal(encodedReader);
            this.attachmentsAccessed = attachmentUnmarshaller.isAccessed();
            return factory.createOMElement(new QName(namespaceURI, localPart), parent);
        }
        catch (JAXBException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    public Object getJaxbObject() {
        return this.jaxbObject;
    }

    public boolean isAttachmentsAccessed() {
        return this.attachmentsAccessed;
    }
}

