/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.jaxp.DOMImplementation;
import org.apache.axiom.ts.jaxp.XSLTImplementation;
import org.apache.axiom.ts.om.container.DocumentElementExtractor;
import org.apache.axiom.ts.om.container.OMContainerExtractor;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

final class OMElementExtractor
extends OMContainerExtractor {
    private final boolean detached;

    OMElementExtractor(boolean detached) {
        this.detached = detached;
    }

    public void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("container", "element");
        testCase.addTestParameter("detached", this.detached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSource getControl(InputStream testFileContent) throws Exception {
        try {
            Document doc = DOMImplementation.XERCES.parse(testFileContent);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XSLTImplementation.XALAN.newTransformerFactory().newTransformer().transform(new DOMSource(doc.getDocumentElement()), new StreamResult(baos));
            InputSource inputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
            return inputSource;
        }
        finally {
            testFileContent.close();
        }
    }

    @Override
    public OMContainer getContainer(OMXMLParserWrapper builder) {
        return builder.getDocumentElement(this.detached);
    }

    @Override
    public XMLStreamReader filter(XMLStreamReader reader) {
        return new DocumentElementExtractor(reader);
    }
}

