/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.container;

import com.google.common.truth.Truth;
import java.util.Iterator;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.container.OMContainerFactory;

public class TestGetDescendants
extends AxiomTestCase {
    private final OMContainerFactory containerFactory;
    private final boolean includeSelf;

    public TestGetDescendants(OMMetaFactory metaFactory, OMContainerFactory containerFactory, boolean includeSelf) {
        super(metaFactory);
        this.containerFactory = containerFactory;
        containerFactory.addTestParameters(this);
        this.includeSelf = includeSelf;
        this.addTestParameter("includeSelf", includeSelf);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMContainer root = this.containerFactory.create(factory);
        OMElement child1 = factory.createOMElement("child", null, root);
        OMText child2 = factory.createOMText(root, "text", 12);
        OMText grandchild1 = factory.createOMText((OMContainer)child1, "text");
        OMComment grandchild2 = factory.createOMComment((OMContainer)child1, "text");
        Iterator it = root.getDescendants(this.includeSelf);
        if (this.includeSelf) {
            Truth.assertThat((Boolean)it.hasNext()).isTrue();
            Truth.assertThat(it.next()).isEqualTo((Object)root);
        }
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        Truth.assertThat(it.next()).isEqualTo((Object)child1);
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        Truth.assertThat(it.next()).isEqualTo((Object)grandchild1);
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        Truth.assertThat(it.next()).isEqualTo((Object)grandchild2);
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        Truth.assertThat(it.next()).isEqualTo((Object)child2);
        Truth.assertThat((Boolean)it.hasNext()).isFalse();
    }
}

