/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.document;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.jaxp.XSLTImplementation;
import org.apache.axiom.ts.xml.XMLSample;

public class TestGetSAXResult
extends ConformanceTestCase {
    private final XSLTImplementation xsltImplementation;

    public TestGetSAXResult(OMMetaFactory metaFactory, XSLTImplementation xsltImplementation, XMLSample file) {
        super(metaFactory, file);
        this.xsltImplementation = xsltImplementation;
        this.addTestParameter("xslt", xsltImplementation.getName());
    }

    protected void runTest() throws Throwable {
        TransformerFactory transformerFactory = this.xsltImplementation.newTransformerFactory();
        StreamSource source = new StreamSource(this.file.getUrl().toString());
        OMDocument document = this.metaFactory.getOMFactory().createOMDocument();
        SAXResult result = document.getSAXResult();
        transformerFactory.newTransformer().transform(source, result);
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMDocument.class, (Object)document))).ignoringWhitespaceInPrologAndEpilog().ignoringRedundantNamespaceDeclarations().expandingEntityReferences().hasSameContentAs((Object)this.file.getUrl());
    }
}

