/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.document;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.SAXParserFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.jaxp.SAXImplementation;
import org.apache.axiom.ts.xml.XMLSample;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TestGetSAXResultSAXParser
extends AxiomTestCase {
    private final SAXImplementation saxImplementation;
    private final XMLSample file;

    public TestGetSAXResultSAXParser(OMMetaFactory metaFactory, SAXImplementation saxImplementation, XMLSample file) {
        super(metaFactory);
        this.saxImplementation = saxImplementation;
        this.file = file;
        this.addTestParameter("parser", saxImplementation.getName());
        this.addTestParameter("file", file.getName());
    }

    protected void runTest() throws Throwable {
        SAXParserFactory factory = this.saxImplementation.newSAXParserFactory();
        factory.setNamespaceAware(true);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        OMDocument document = this.metaFactory.getOMFactory().createOMDocument();
        ContentHandler handler = document.getSAXResult().getHandler();
        reader.setContentHandler(handler);
        reader.setDTDHandler((DTDHandler)((Object)handler));
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        reader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
        reader.parse(new InputSource(this.file.getUrl().toString()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        document.serialize((OutputStream)baos);
        InputSource actual = new InputSource();
        actual.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
        actual.setSystemId(this.file.getUrl().toString());
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that((Object)actual)).ignoringWhitespaceInPrologAndEpilog().expandingEntityReferences().hasSameContentAs((Object)this.file.getUrl());
    }
}

