/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.AddAttributeStrategy;

public class TestAddAttributeMultiple
extends AxiomTestCase {
    private final AddAttributeStrategy strategy;

    public TestAddAttributeMultiple(OMMetaFactory metaFactory, AddAttributeStrategy strategy) {
        super(metaFactory);
        this.strategy = strategy;
        strategy.addTestParameters(this);
    }

    protected void runTest() throws Throwable {
        String expectedXML = "<AttributeTester xmlns:myAttr2NS=\"http://test-attributes-2.org\" xmlns:myAttr1NS=\"http://test-attributes-1.org\" myAttr2NS:attrNumber=\"2\" myAttr1NS:attrNumber=\"1\" />";
        OMFactory omFactory = this.metaFactory.getOMFactory();
        OMNamespace attrNS1 = omFactory.createOMNamespace("http://test-attributes-1.org", "myAttr1NS");
        OMNamespace attrNS2 = omFactory.createOMNamespace("http://test-attributes-2.org", "myAttr2NS");
        OMElement omElement = omFactory.createOMElement("AttributeTester", null);
        this.strategy.addAttribute(omElement, "attrNumber", attrNS1, "1");
        this.strategy.addAttribute(omElement, "attrNumber", attrNS2, "2");
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)omElement))).hasSameContentAs((Object)expectedXML);
    }
}

