/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.io.Reader;
import java.io.StringReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;

public class TestDetachWithDifferentBuilder
extends AxiomTestCase {
    public TestDetachWithDifferentBuilder(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        String xml1 = "<root><a/><b/></root>";
        String xml2 = "<child>test</child>";
        OMElement parent = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader(xml1)).getDocumentElement();
        OMElement child = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader(xml2)).getDocumentElement(true);
        parent.getFirstOMChild().insertSiblingBefore((OMNode)child);
        child.detach();
        Truth.assertThat((Boolean)child.isComplete()).isFalse();
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)parent))).hasSameContentAs((Object)xml1);
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)child))).hasSameContentAs((Object)xml2);
    }
}

