/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetAllDeclaredNamespacesRemove
extends AxiomTestCase {
    public TestGetAllDeclaredNamespacesRemove(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        List<String> prefixes = Arrays.asList("a", "b", "c");
        for (String prefixToRemove : prefixes) {
            OMElement element = factory.createOMElement("test", null);
            for (String prefix : prefixes) {
                element.declareNamespace("urn:" + prefix, prefix);
            }
            HashSet<String> seenPrefixes = new HashSet<String>();
            Iterator it = element.getAllDeclaredNamespaces();
            while (it.hasNext()) {
                OMNamespace ns = (OMNamespace)it.next();
                String prefix = ns.getPrefix();
                if (prefix.equals(prefixToRemove)) {
                    it.remove();
                }
                seenPrefixes.add(prefix);
            }
            Truth.assertThat(seenPrefixes).containsAllIn(prefixes);
            for (String prefix : prefixes) {
                OMNamespace ns = element.findNamespaceURI(prefix);
                if (prefix.equals(prefixToRemove)) {
                    Truth.assertThat((Object)ns).isNull();
                    continue;
                }
                Truth.assertThat((Object)ns).isNotNull();
                Truth.assertThat((String)ns.getNamespaceURI()).isEqualTo((Object)("urn:" + prefix));
            }
        }
    }
}

