/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetXMLStreamReaderWithIncompleteDescendant
extends AxiomTestCase {
    private final boolean cache;

    public TestGetXMLStreamReaderWithIncompleteDescendant(OMMetaFactory metaFactory, boolean cache) {
        super(metaFactory);
        this.cache = cache;
        this.addTestParameter("cache", cache);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement root = factory.createOMElement(new QName("root"));
        OMElement child = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader("<a>test</a>")).getDocumentElement(true);
        root.addChild((OMNode)child);
        TestGetXMLStreamReaderWithIncompleteDescendant.assertFalse((boolean)child.isComplete());
        XMLStreamReader stream = root.getXMLStreamReader(this.cache);
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((int)1, (int)stream.next());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((String)"root", (String)stream.getLocalName());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((int)1, (int)stream.next());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((String)"a", (String)stream.getLocalName());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((int)4, (int)stream.next());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((String)"test", (String)stream.getText());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((int)2, (int)stream.next());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((String)"a", (String)stream.getLocalName());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((int)2, (int)stream.next());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((String)"root", (String)stream.getLocalName());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((int)8, (int)stream.next());
        TestGetXMLStreamReaderWithIncompleteDescendant.assertEquals((boolean)this.cache, (boolean)child.isComplete());
    }
}

