/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetXMLStreamReaderWithNamespaceURIInterning
extends AxiomTestCase {
    public TestGetXMLStreamReaderWithNamespaceURIInterning(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMNamespace ns1 = factory.createOMNamespace(new String("urn:ns1"), "p");
        OMNamespace ns2 = factory.createOMNamespace(new String("urn:ns2"), "q");
        OMElement root = factory.createOMElement("root", ns1);
        root.addAttribute("attr", "value", ns2);
        factory.createOMElement("child", ns2, (OMContainer)root);
        OMXMLStreamReaderConfiguration configuration = new OMXMLStreamReaderConfiguration();
        configuration.setNamespaceURIInterning(true);
        XMLStreamReader reader = root.getXMLStreamReader(true, configuration);
        reader.nextTag();
        TestGetXMLStreamReaderWithNamespaceURIInterning.assertInterned(reader.getNamespaceURI());
        TestGetXMLStreamReaderWithNamespaceURIInterning.assertInterned(reader.getAttributeNamespace(0));
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            TestGetXMLStreamReaderWithNamespaceURIInterning.assertInterned(reader.getNamespaceURI(i));
        }
        reader.nextTag();
        TestGetXMLStreamReaderWithNamespaceURIInterning.assertInterned(reader.getNamespaceURI("p"));
        NamespaceContext nc = reader.getNamespaceContext();
        TestGetXMLStreamReaderWithNamespaceURIInterning.assertInterned(nc.getNamespaceURI("p"));
    }

    private static void assertInterned(String s) {
        TestGetXMLStreamReaderWithNamespaceURIInterning.assertSame((String)"String not interned", (Object)s.intern(), (Object)s);
    }
}

