/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.sourcedelement.TestDocument;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;

public class TestName1DefaultPrefix
extends AxiomTestCase {
    public TestName1DefaultPrefix(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory f = this.metaFactory.getOMFactory();
        OMNamespace rootNS = f.createOMNamespace("http://sampleroot", "rootPrefix");
        OMNamespace ns = f.createOMNamespace("http://www.sosnoski.com/uwjws/library", null);
        OMSourcedElement element = f.createOMElement((OMDataSource)new PullOMDataSource(TestDocument.DOCUMENT1.getContent()), "library", ns);
        OMElement root = f.createOMElement("root", rootNS);
        root.addChild((OMNode)element);
        TestName1DefaultPrefix.assertTrue((boolean)element.getLocalName().equals("library"));
        TestName1DefaultPrefix.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals("http://www.sosnoski.com/uwjws/library"));
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlwriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        root.serialize((Writer)writer);
        xmlwriter.flush();
        String result = writer.toString();
        TestName1DefaultPrefix.assertTrue((boolean)element.getLocalName().equals("library"));
        TestName1DefaultPrefix.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals("http://www.sosnoski.com/uwjws/library"));
        TestName1DefaultPrefix.assertTrue((boolean)element.getNamespace().getPrefix().equals(""));
        TestName1DefaultPrefix.assertTrue((element.getDefaultNamespace() != null ? 1 : 0) != 0);
        TestName1DefaultPrefix.assertTrue((String)("Serialized text error" + result), (result.indexOf("1930110111") > 0 ? 1 : 0) != 0);
        writer = new StringWriter();
        xmlwriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        root.serialize((Writer)writer);
        xmlwriter.flush();
        result = writer.toString();
        TestName1DefaultPrefix.assertTrue((boolean)element.getLocalName().equals("library"));
        TestName1DefaultPrefix.assertTrue((boolean)element.getNamespace().getNamespaceURI().equals("http://www.sosnoski.com/uwjws/library"));
        TestName1DefaultPrefix.assertTrue((boolean)element.getNamespace().getPrefix().equals(""));
        TestName1DefaultPrefix.assertTrue((element.getDefaultNamespace() != null ? 1 : 0) != 0);
        TestName1DefaultPrefix.assertTrue((String)("Serialized text error" + result), (result.indexOf("1930110111") > 0 ? 1 : 0) != 0);
    }
}

