/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.om.ds.InputStreamDataSource;
import org.apache.axiom.ts.AxiomTestCase;

public class TestSetDataSource
extends AxiomTestCase {
    public TestSetDataSource(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
    }

    public void testOMSEReplacement() throws Exception {
        String ENCODING = "utf-8";
        String payload1 = "<tns:myPayload xmlns:tns=\"urn://test\">Payload One</tns:myPayload>";
        String payload2 = "<tns:myPayload xmlns:tns=\"urn://test\">Payload Two</tns:myPayload>";
        ByteArrayDataSource bads1 = new ByteArrayDataSource(payload1.getBytes(ENCODING), ENCODING);
        ByteArrayDataSource bads2 = new ByteArrayDataSource(payload2.getBytes(ENCODING), ENCODING);
        InputStreamDataSource isds1 = new InputStreamDataSource((InputStream)new ByteArrayInputStream(payload1.getBytes(ENCODING)), ENCODING);
        InputStreamDataSource isds2 = new InputStreamDataSource((InputStream)new ByteArrayInputStream(payload2.getBytes(ENCODING)), ENCODING);
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement parent = factory.createOMElement("parent", null);
        OMSourcedElement omse = factory.createOMElement((OMDataSource)bads1, "myPayload", factory.createOMNamespace("urn://test", "tns"));
        parent.addChild((OMNode)omse);
        OMNode firstChild = parent.getFirstOMChild();
        TestSetDataSource.assertTrue((String)"Expected OMSourcedElement child", (boolean)(firstChild instanceof OMSourcedElement));
        OMSourcedElement child = (OMSourcedElement)firstChild;
        TestSetDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        TestSetDataSource.assertTrue((String)"OMSourcedElement should be backed by a ByteArrayDataSource", (boolean)(child.getDataSource() instanceof ByteArrayDataSource));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        parent.serialize((OutputStream)baos);
        String output = baos.toString(ENCODING);
        TestSetDataSource.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload1) > 0 ? 1 : 0) != 0);
        TestSetDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        child.setDataSource((OMDataSource)bads2);
        baos = new ByteArrayOutputStream();
        parent.serialize((OutputStream)baos);
        output = baos.toString(ENCODING);
        TestSetDataSource.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload2) > 0 ? 1 : 0) != 0);
        TestSetDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        child.setDataSource((OMDataSource)isds1);
        baos = new ByteArrayOutputStream();
        parent.serialize((OutputStream)baos);
        output = baos.toString(ENCODING);
        TestSetDataSource.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload1) > 0 ? 1 : 0) != 0);
        child.setDataSource((OMDataSource)isds2);
        baos = new ByteArrayOutputStream();
        parent.serialize((OutputStream)baos);
        output = baos.toString(ENCODING);
        TestSetDataSource.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload2) > 0 ? 1 : 0) != 0);
    }
}

