/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement.util;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;

public final class PushOMDataSource
extends AbstractPushOMDataSource {
    private final OMFactory factory;
    private final String data;
    private final boolean destructive;
    private boolean destroyed;

    public PushOMDataSource(OMFactory factory, String data, boolean destructive) {
        this.factory = factory;
        this.data = data;
        this.destructive = destructive;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        if (this.destroyed) {
            throw new IllegalStateException("The OMDataSource has already been consumed");
        }
        if (this.destructive) {
            this.destroyed = true;
        }
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.factory, (Reader)new StringReader(this.data));
        builder.getDocumentElement().serializeAndConsume(writer);
        builder.close();
    }

    public boolean isDestructiveWrite() {
        return this.destructive;
    }
}

