/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.testutils.activation.RandomDataSource;
import org.apache.axiom.testutils.io.ByteStreamComparator;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.util.base64.Base64DecodingOutputStreamWriter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TestBase64StreamingWithGetSAXSource
extends AxiomTestCase {
    public TestBase64StreamingWithGetSAXSource(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement elem = factory.createOMElement("test", null);
        RandomDataSource ds = new RandomDataSource(654321L, Runtime.getRuntime().maxMemory());
        OMText text = factory.createOMText((Object)new DataHandler((DataSource)ds), false);
        elem.addChild((OMNode)text);
        SAXSource saxSource = elem.getSAXSource(true);
        XMLReader xmlReader = saxSource.getXMLReader();
        xmlReader.setContentHandler(new Base64Comparator(ds.getInputStream()));
        xmlReader.parse(saxSource.getInputSource());
    }

    private static class Base64Comparator
    extends DefaultHandler {
        private final Writer out;

        public Base64Comparator(InputStream expected) {
            this.out = new Base64DecodingOutputStreamWriter((OutputStream)new ByteStreamComparator(expected));
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.out.write(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            try {
                this.out.close();
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
    }
}

