/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.body;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SampleBasedSOAPTestCase;

public class TestCloneOMElement
extends SampleBasedSOAPTestCase {
    public TestCloneOMElement(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec, SOAPSampleSet.WSA);
    }

    @Override
    protected void runTest(SOAPEnvelope envelope) throws Throwable {
        SOAPBody body = envelope.getBody();
        OMElement firstClonedBodyElement = body.cloneOMElement();
        OMElement secondClonedBodyElement = body.cloneOMElement();
        TestCloneOMElement.assertFalse((boolean)(firstClonedBodyElement instanceof SOAPBody));
        TestCloneOMElement.assertFalse((boolean)(secondClonedBodyElement instanceof SOAPBody));
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)firstClonedBodyElement))).ignoringNamespaceDeclarations().hasSameContentAs(XMLTruth.xml(OMElement.class, (Object)body));
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)secondClonedBodyElement))).ignoringNamespaceDeclarations().hasSameContentAs(XMLTruth.xml(OMElement.class, (Object)body));
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)secondClonedBodyElement))).hasSameContentAs(XMLTruth.xml(OMElement.class, (Object)firstClonedBodyElement));
        TestCloneOMElement.assertNull((Object)firstClonedBodyElement.getParent());
        TestCloneOMElement.assertNull((Object)secondClonedBodyElement.getParent());
        envelope.close(false);
    }
}

