/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.builder;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.om.ds.custombuilder.ByteArrayCustomBuilder;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.soap.SOAPSample;
import org.apache.axiom.ts.soap.SOAPSampleAdapter;
import org.xml.sax.InputSource;

public class TestRegisterCustomBuilderForPayload
extends AxiomTestCase {
    private final SOAPSample message;

    public TestRegisterCustomBuilderForPayload(OMMetaFactory metaFactory, SOAPSample message) {
        super(metaFactory);
        this.message = message;
        this.addTestParameter("message", message.getName());
    }

    protected void runTest() throws Throwable {
        SOAPModelBuilder builder = ((SOAPSampleAdapter)this.message.getAdapter(SOAPSampleAdapter.class)).getBuilder(this.metaFactory);
        ((StAXSOAPModelBuilder)builder).registerCustomBuilderForPayload((CustomBuilder)new ByteArrayCustomBuilder("utf-8"));
        OMElement payload = builder.getSOAPEnvelope().getBody().getFirstElement();
        if (this.message.getPayload() == null) {
            TestRegisterCustomBuilderForPayload.assertNull((Object)payload);
        } else {
            TestRegisterCustomBuilderForPayload.assertTrue((boolean)(payload instanceof OMSourcedElement));
            ByteArrayDataSource.ByteArray byteArray = (ByteArrayDataSource.ByteArray)((OMSourcedElement)payload).getObject(ByteArrayDataSource.class);
            TestRegisterCustomBuilderForPayload.assertNotNull((Object)byteArray);
            InputSource is = new InputSource(new ByteArrayInputStream(byteArray.bytes));
            is.setEncoding(byteArray.encoding);
            ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that((Object)is)).ignoringNamespaceDeclarations().hasSameContentAs((Object)this.message.getPayloadInputSource());
        }
    }
}

