/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.envelope;

import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestSerializeAndConsumeWithOMSEInBody
extends SOAPTestCase {
    public TestSerializeAndConsumeWithOMSEInBody(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.createSOAPEnvelope();
        SOAPBody body = this.soapFactory.createSOAPBody();
        envelope.addChild((OMNode)body);
        OMNamespace ns = this.soapFactory.createOMNamespace("http://ns1", "d");
        OMSourcedElement payload = this.soapFactory.createOMElement((OMDataSource)new DummySource(), "dummy", ns);
        payload.setNamespace(ns);
        body.addChild((OMNode)payload);
        payload.getBuilder().setCache(false);
        StringWriter writer = new StringWriter();
        envelope.serializeAndConsume((Writer)writer);
    }

    private static class DummySource
    implements OMDataSource {
        private XMLStreamReader reader;
        private String xml = "<?xml version='1.0'?><d:dummy name='1' xmlns:d='http://ns1'>hello<mixed/>world</d:dummy>";

        private DummySource() {
        }

        public XMLStreamReader getReader() throws XMLStreamException {
            return StAXUtils.createXMLStreamReader((Reader)new StringReader(this.xml));
        }

        public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        }

        public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        }

        public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        }
    }
}

