/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.headerblock;

import com.google.common.truth.Truth;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPCloneOptions;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestClone
extends SOAPTestCase {
    private final Boolean processed;

    public TestClone(OMMetaFactory metaFactory, SOAPSpec spec, Boolean processed) {
        super(metaFactory, spec);
        this.processed = processed;
        this.addTestParameter("processed", String.valueOf(processed));
    }

    private void checkProcessed(SOAPHeader clonedHeader, SOAPHeaderBlock orgHeaderBlock) {
        SOAPHeaderBlock clonedHeaderBlock = (SOAPHeaderBlock)clonedHeader.getFirstChildWithName(orgHeaderBlock.getQName());
        Truth.assertThat((Boolean)clonedHeaderBlock.isProcessed()).isEqualTo((Object)(this.processed == null ? orgHeaderBlock.isProcessed() : this.processed.booleanValue()));
    }

    protected void runTest() throws Throwable {
        SOAPHeader header = this.soapFactory.createSOAPHeader();
        OMNamespace ns = this.soapFactory.createOMNamespace("urn:test", "p");
        SOAPHeaderBlock unprocessedHeaderBlock = header.addHeaderBlock("unprocessed", ns);
        SOAPHeaderBlock processedHeaderBlock = header.addHeaderBlock("processed", ns);
        processedHeaderBlock.setProcessed();
        SOAPCloneOptions options = new SOAPCloneOptions();
        options.setPreserveModel(true);
        options.setProcessedFlag(this.processed);
        SOAPHeader clonedHeader = (SOAPHeader)header.clone((OMCloneOptions)options);
        this.checkProcessed(clonedHeader, unprocessedHeaderBlock);
        this.checkProcessed(clonedHeader, processedHeaderBlock);
    }
}

