/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.message;

import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestClone
extends SOAPTestCase {
    private final boolean preserveModel;

    public TestClone(OMMetaFactory metaFactory, SOAPSpec spec, boolean preserveModel) {
        super(metaFactory, spec);
        this.preserveModel = preserveModel;
        this.addTestParameter("preserveModel", preserveModel);
    }

    protected void runTest() throws Throwable {
        SOAPMessage message = this.soapFactory.createSOAPMessage();
        message.addChild((OMNode)this.soapFactory.getDefaultEnvelope());
        OMCloneOptions options = new OMCloneOptions();
        options.setPreserveModel(this.preserveModel);
        OMInformationItem clone = message.clone(options);
        if (this.preserveModel) {
            TestClone.assertTrue((boolean)(clone instanceof SOAPMessage));
        } else {
            TestClone.assertTrue((boolean)(clone instanceof OMDocument));
            TestClone.assertFalse((boolean)(clone instanceof SOAPMessage));
        }
        OMElement envelope = ((OMDocument)clone).getOMDocumentElement();
        if (this.preserveModel) {
            TestClone.assertTrue((boolean)(envelope instanceof SOAPEnvelope));
        } else {
            TestClone.assertFalse((boolean)(envelope instanceof SOAPEnvelope));
        }
        TestClone.assertEquals((String)"Envelope", (String)envelope.getLocalName());
        TestClone.assertEquals((String)this.spec.getEnvelopeNamespaceURI(), (String)envelope.getNamespaceURI());
    }
}

