/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap11.faultreason;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestGetTextWithCDATA
extends SOAPTestCase {
    public TestGetTextWithCDATA(OMMetaFactory metaFactory) {
        super(metaFactory, SOAPSpec.SOAP11);
    }

    protected void runTest() throws Throwable {
        String soap11Fault = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body><SOAP-ENV:Fault><faultcode>SOAP-ENV:Server</faultcode><faultstring xml:lang=\"en\"><![CDATA[handleMessage throws SOAPFaultException for ThrowsSOAPFaultToClientHandlersTest]]></faultstring><detail><somefaultentry/></detail><faultactor>faultActor</faultactor></SOAP-ENV:Fault></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        XMLStreamReader soap11Parser = StAXUtils.createXMLStreamReader((StAXParserConfiguration)TEST_PARSER_CONFIGURATION, (Reader)new StringReader(soap11Fault));
        SOAPModelBuilder soap11Builder = OMXMLBuilderFactory.createStAXSOAPModelBuilder((OMMetaFactory)this.metaFactory, (XMLStreamReader)soap11Parser);
        OMElement element = soap11Builder.getDocumentElement();
        element.build();
        TestGetTextWithCDATA.assertTrue((boolean)(element instanceof SOAPEnvelope));
        SOAPEnvelope se = (SOAPEnvelope)element;
        SOAPFault fault = se.getBody().getFault();
        SOAPFaultReason reason = fault.getReason();
        TestGetTextWithCDATA.assertTrue((boolean)reason.getText().equals("handleMessage throws SOAPFaultException for ThrowsSOAPFaultToClientHandlersTest"));
        soap11Parser.close();
    }
}

