/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.envelope;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.lifecycle.DataHandlerExt;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.testutils.activation.TestDataSource;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.ts.AxiomTestCase;

public class TestMTOMForwardStreaming
extends AxiomTestCase {
    private final boolean buildSOAPPart;

    public TestMTOMForwardStreaming(OMMetaFactory metaFactory, boolean buildSOAPPart) {
        super(metaFactory);
        this.addTestParameter("buildSOAPPart", buildSOAPPart);
        this.buildSOAPPart = buildSOAPPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        TestDataSource ds1 = new TestDataSource(65, Runtime.getRuntime().maxMemory());
        TestDataSource ds2 = new TestDataSource(66, Runtime.getRuntime().maxMemory());
        SOAPFactory factory = this.metaFactory.getSOAP12Factory();
        final SOAPEnvelope orgEnvelope = factory.createSOAPEnvelope();
        SOAPBody orgBody = factory.createSOAPBody(orgEnvelope);
        OMElement orgBodyElement = factory.createOMElement("test", factory.createOMNamespace("urn:test", "p"), (OMContainer)orgBody);
        OMElement orgData1 = factory.createOMElement("data", null, (OMContainer)orgBodyElement);
        orgData1.addChild((OMNode)factory.createOMText((Object)new DataHandler((DataSource)ds1), true));
        OMElement orgData2 = factory.createOMElement("data", null, (OMContainer)orgBodyElement);
        orgData2.addChild((OMNode)factory.createOMText((Object)new DataHandler((DataSource)ds2), true));
        final OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        format.setSOAP11(false);
        final String contentType = format.getContentType();
        final PipedOutputStream pipe1Out = new PipedOutputStream();
        final PipedInputStream pipe1In = new PipedInputStream(pipe1Out);
        Thread producerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        orgEnvelope.serialize((OutputStream)pipe1Out, format);
                    }
                    finally {
                        pipe1Out.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        producerThread.start();
        final PipedOutputStream pipe2Out = new PipedOutputStream();
        PipedInputStream pipe2In = new PipedInputStream(pipe2Out);
        Thread forwarderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Attachments attachments = new Attachments((InputStream)pipe1In, contentType);
                        SOAPEnvelope envelope = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)TestMTOMForwardStreaming.this.metaFactory, (Attachments)attachments).getSOAPEnvelope();
                        if (TestMTOMForwardStreaming.this.buildSOAPPart) {
                            envelope.build();
                        }
                        envelope.serializeAndConsume((OutputStream)pipe2Out, format);
                    }
                    finally {
                        pipe2Out.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        forwarderThread.start();
        try {
            Attachments attachments = new Attachments((InputStream)pipe2In, contentType);
            SOAPEnvelope envelope = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Attachments)attachments).getSOAPEnvelope();
            OMElement bodyElement = envelope.getBody().getFirstElement();
            Iterator it = bodyElement.getChildElements();
            OMElement data1 = (OMElement)it.next();
            OMElement data2 = (OMElement)it.next();
            IOTestUtils.compareStreams((InputStream)ds1.getInputStream(), (InputStream)((DataHandlerExt)((OMText)data1.getFirstOMChild()).getDataHandler()).readOnce());
            IOTestUtils.compareStreams((InputStream)ds2.getInputStream(), (InputStream)((DataHandlerExt)((OMText)data2.getFirstOMChild()).getDataHandler()).readOnce());
        }
        finally {
            pipe2In.close();
        }
    }
}

